/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.settings.BooleanOption;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

public final class ConfigScreen
extends Screen {
    private static final int TITLE_MARGIN = 8;
    private static final int OPTIONS_LIST_MARGIN = 24;
    private static final int OPTIONS_LIST_BOTTOM_MARGIN = 32;
    private static final int OPTION_HEIGHT = 25;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int DONE_BUTTON_BOTTOM_MARGIN = 6;
    private static final String KEY_TITLE = "hourglass.configgui.title";
    private static final String KEY_CLOCK_ALIGNMENT = "hourglass.configgui.clockAlignment";
    private static final String KEY_CLOCK_SCALE = "hourglass.configgui.clockScale";
    private static final String KEY_CLOCK_MARGIN = "hourglass.configgui.clockMargin";
    private static final String KEY_PREVENT_CLOCK_WOBBLE = "hourglass.configgui.preventClockWobble";
    private static final String KEY_PIXELS = "hourglass.configgui.pixels";
    private static final String KEY_DONE = "gui.done";
    private static final String KEY_GENERIC_OPTION = "options.generic_value";
    protected Screen lastScreen;
    protected OptionsRowList optionsList;
    protected Button doneButton;
    private ScreenAlignment clockAlignment;
    private int clockScale;
    private int clockMargin;
    private boolean preventClockWobble;

    @SubscribeEvent
    public static void onConstructModEvent(FMLConstructModEvent event) {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfigScreen((Screen)screen));
    }

    public ConfigScreen(Screen lastScreen) {
        super((ITextComponent)TextWrapper.translation(KEY_TITLE).get());
        this.lastScreen = lastScreen;
    }

    protected void func_231160_c_() {
        this.fetchSettings();
        this.optionsList = new OptionsRowList(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 24, this.field_230709_l_ - 32, 25);
        this.optionsList.func_214333_a((AbstractOption)new IteratableOption(KEY_CLOCK_ALIGNMENT, (settings, value) -> {
            this.clockAlignment = ScreenAlignment.values()[(this.clockAlignment.ordinal() + value) % ScreenAlignment.values().length];
        }, (settings, option) -> (ITextComponent)ConfigScreen.genericOptionText(TextWrapper.translation(KEY_CLOCK_ALIGNMENT).get(), TextWrapper.translation(this.clockAlignment.getKey()).get()).get()));
        this.optionsList.func_214333_a((AbstractOption)new SliderPercentageOption(KEY_CLOCK_SCALE, 0.0, 128.0, 4.0f, settings -> this.clockScale, (settings, value) -> {
            this.clockScale = value.intValue();
        }, (settings, option) -> (ITextComponent)ConfigScreen.pixelOptionText(KEY_CLOCK_SCALE, option.func_216729_a(settings)).get()));
        this.optionsList.func_214333_a((AbstractOption)new SliderPercentageOption(KEY_CLOCK_MARGIN, 0.0, 128.0, 4.0f, settings -> this.clockMargin, (settings, value) -> {
            this.clockMargin = value.intValue();
        }, (settings, option) -> (ITextComponent)ConfigScreen.pixelOptionText(KEY_CLOCK_MARGIN, option.func_216729_a(settings)).get()));
        this.optionsList.func_214333_a((AbstractOption)new BooleanOption(KEY_PREVENT_CLOCK_WOBBLE, settings -> this.preventClockWobble, (settings, value) -> {
            this.preventClockWobble = value;
        }));
        this.func_230481_d_((IGuiEventListener)this.optionsList);
        int doneX = (this.field_230708_k_ - 200) / 2;
        int doneY = this.field_230709_l_ - 20 - 6;
        TextWrapper doneText = TextWrapper.translation(KEY_DONE);
        this.doneButton = new Button(doneX, doneY, 200, 20, (ITextComponent)doneText.get(), button -> this.func_231175_as__());
        this.func_230480_a_((Widget)this.doneButton);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.optionsList.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        ConfigScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_231175_as__() {
        this.saveSettings();
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    private void fetchSettings() {
        this.clockAlignment = (ScreenAlignment)((Object)HourglassConfig.CLIENT_CONFIG.clockAlignment.get());
        this.clockScale = (Integer)HourglassConfig.CLIENT_CONFIG.clockScale.get();
        this.clockMargin = (Integer)HourglassConfig.CLIENT_CONFIG.clockMargin.get();
        this.preventClockWobble = (Boolean)HourglassConfig.CLIENT_CONFIG.preventClockWobble.get();
    }

    private void saveSettings() {
        HourglassConfig.CLIENT_CONFIG.clockAlignment.set((Object)this.clockAlignment);
        HourglassConfig.CLIENT_CONFIG.clockScale.set((Object)this.clockScale);
        HourglassConfig.CLIENT_CONFIG.clockMargin.set((Object)this.clockMargin);
        HourglassConfig.CLIENT_CONFIG.preventClockWobble.set((Object)this.preventClockWobble);
    }

    public static TextWrapper genericOptionText(Object ... args) {
        return TextWrapper.translation(KEY_GENERIC_OPTION, args);
    }

    public static TextWrapper pixelOptionText(String key, double pixelCount) {
        return TextWrapper.translation(KEY_GENERIC_OPTION, TextWrapper.translation(key).get(), TextWrapper.translation(KEY_PIXELS, (int)pixelCount).get());
    }
}

