/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SleepGui {
    private static ItemStack clock = new ItemStack((IItemProvider)Items.field_151113_aN);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && ((Boolean)HourglassConfig.CLIENT_CONFIG.preventClockWobble.get()).booleanValue() && SleepGui.clockEnabled() && minecraft.field_71441_e != null && !minecraft.func_147113_T()) {
            minecraft.func_175599_af().func_184393_a(clock, (World)minecraft.field_71441_e, (LivingEntity)minecraft.field_71439_g);
        }
    }

    @SubscribeEvent
    public static void onGuiEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof SleepInMultiplayerScreen && SleepGui.clockEnabled()) {
            SleepGui.renderSleepInterface(event.getGui().getMinecraft());
        }
    }

    public static void renderSleepInterface(Minecraft minecraft) {
        Screen screen = minecraft.field_71462_r;
        if (!(screen instanceof SleepInMultiplayerScreen)) {
            return;
        }
        int scale = (Integer)HourglassConfig.CLIENT_CONFIG.clockScale.get();
        int margin = (Integer)HourglassConfig.CLIENT_CONFIG.clockMargin.get();
        ScreenAlignment alignment = (ScreenAlignment)((Object)HourglassConfig.CLIENT_CONFIG.clockAlignment.get());
        float x = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.BOTTOM_LEFT ? (float)margin : (alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.BOTTOM_CENTER ? (float)(screen.field_230708_k_ / 2 - scale / 2) : (float)(screen.field_230708_k_ - scale - margin));
        float y = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.TOP_RIGHT ? (float)margin : (alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.CENTER_RIGHT ? (float)(screen.field_230709_l_ / 2 - scale / 2) : (float)(screen.field_230709_l_ - scale - margin));
        SleepGui.renderClock(minecraft, x, y, scale);
    }

    public static void renderClock(Minecraft minecraft, float x, float y, float scale) {
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        scale /= 16.0f;
        MatrixStack stack = new MatrixStack();
        stack.func_227860_a_();
        RenderHelper.func_227783_c_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)0.0f);
        itemRenderer.func_180450_b(clock, 0, 0);
        RenderHelper.func_227784_d_();
        stack.func_227865_b_();
    }

    public static boolean clockEnabled() {
        return (Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get() != false && (Boolean)HourglassConfig.SERVER_CONFIG.displayBedClock.get() != false;
    }
}

