/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.lavabucket.hourglass.command.config.ConfigCommand;
import net.lavabucket.hourglass.command.config.ConfigCommandEntry;
import net.lavabucket.hourglass.config.ConfigSynchronizer;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.TimeService;
import net.lavabucket.hourglass.time.TimeServiceManager;
import net.lavabucket.hourglass.time.effects.EffectCondition;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HourglassCommand {
    private static final DoubleArgumentType TIME_SPEED_ARGUMENT = DoubleArgumentType.doubleArg((double)0.0, (double)24000.0);

    @SubscribeEvent
    public static void onRegisterCommandEvent(RegisterCommandsEvent event) {
        ConfigCommand configCommand = new ConfigCommand().setQuerySuccessHandler(HourglassCommand::onQuerySuccess).setModifySuccessHandler(HourglassCommand::onModifySuccess).setModifyFailureHandler(HourglassCommand::onModifyFailure).register(HourglassConfig.SERVER_CONFIG.daySpeed, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.nightSpeed, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.enableSleepFeature).register(HourglassConfig.SERVER_CONFIG.sleepSpeedMin, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.sleepSpeedMax, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.sleepSpeedAll, (ArgumentType<Double>)DoubleArgumentType.doubleArg((double)-1.0, (double)24000.0)).register(HourglassConfig.SERVER_CONFIG.sleepSpeedCurve, (ArgumentType<Double>)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).register(HourglassConfig.SERVER_CONFIG.clearWeatherOnWake).register(HourglassConfig.SERVER_CONFIG.displayBedClock).register(HourglassConfig.SERVER_CONFIG.allowDaySleep).register(HourglassConfig.SERVER_CONFIG.weatherEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.randomTickEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.baseRandomTickSpeed, (ArgumentType<Integer>)IntegerArgumentType.integer((int)0)).register(HourglassConfig.SERVER_CONFIG.potionEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.hungerEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.blockEntityEffect, EffectCondition.class);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"hourglass").requires(source -> source.func_197034_c(2))).then(configCommand.build((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a((String)"config")))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"query").then(Commands.func_197057_a((String)"timeSpeed").executes(HourglassCommand::onTimeSpeedQuery))).then(Commands.func_197057_a((String)"sleeperCount").executes(HourglassCommand::onSleeperCountQuery))));
    }

    public static <T> void onQuerySuccess(CommandContext<CommandSource> context, ConfigCommandEntry<T> entry) {
        TextWrapper response = TextWrapper.translation("commands.hourglass.config.query", entry.getIdentifier(), entry.getConfigValue().get().toString());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)response.get(), false);
    }

    public static <T> void onModifySuccess(CommandContext<CommandSource> context, ConfigCommandEntry<T> entry) {
        ConfigSynchronizer.syncConfigWithClients();
        TextWrapper response = TextWrapper.translation("commands.hourglass.config.set", entry.getIdentifier(), entry.getConfigValue().get());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)response.get(), true);
    }

    public static <T> void onModifyFailure(CommandContext<CommandSource> context, ConfigCommandEntry<T> entry) {
        TextWrapper response = TextWrapper.translation("commands.hourglass.config.failure", entry.getIdentifier(), entry.getConfigValue().get());
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)response.get());
    }

    public static int onTimeSpeedQuery(CommandContext<CommandSource> context) {
        ServerLevelWrapper wrapper = new ServerLevelWrapper((IWorld)((CommandSource)context.getSource()).func_197023_e());
        TimeService service = TimeServiceManager.service;
        if (service == null || !service.managesLevel(wrapper)) {
            TextWrapper response = TextWrapper.translation("commands.hourglass.query.levelNotApplicable");
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)response.get());
            return 0;
        }
        TextWrapper response = TextWrapper.translation("commands.hourglass.query.timeSpeed.success", service.getTimeSpeed(service.getDayTime()));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)response.get(), false);
        return 1;
    }

    public static int onSleeperCountQuery(CommandContext<CommandSource> context) {
        ServerLevelWrapper wrapper = new ServerLevelWrapper((IWorld)((CommandSource)context.getSource()).func_197023_e());
        TimeService service = TimeServiceManager.service;
        if (service == null || !service.managesLevel(wrapper)) {
            TextWrapper response = TextWrapper.translation("commands.hourglass.query.levelNotApplicable");
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)response.get());
            return 0;
        }
        TextWrapper response = TextWrapper.translation("commands.hourglass.query.sleeperCount.success", service.sleepStatus.percentage(), service.sleepStatus.amountSleeping(), service.sleepStatus.amountActive());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)response.get(), false);
        return 1;
    }
}

