/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.command.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCommandEntry<T> {
    protected ForgeConfigSpec.ConfigValue<T> configValue;
    protected ArgumentType<T> argumentType;
    protected Class<T> valueClass;
    private String identifier;

    public ConfigCommandEntry(ForgeConfigSpec.ConfigValue<T> configValue, ArgumentType<T> argumentType, Class<T> valueClass) {
        this(configValue, argumentType, valueClass, false);
    }

    public ConfigCommandEntry(ForgeConfigSpec.ConfigValue<T> configValue, ArgumentType<T> argumentType, Class<T> valueClass, boolean useFullPath) {
        this.configValue = configValue;
        this.argumentType = argumentType;
        this.valueClass = valueClass;
        this.identifier = useFullPath ? String.join((CharSequence)".", configValue.getPath()) : (String)configValue.getPath().get(configValue.getPath().size() - 1);
    }

    public ConfigCommandEntry(ForgeConfigSpec.ConfigValue<T> configValue, ArgumentType<T> argumentType, Class<T> valueClass, String identifier) {
        this.configValue = configValue;
        this.argumentType = argumentType;
        this.valueClass = valueClass;
        this.identifier = identifier;
    }

    public ForgeConfigSpec.ConfigValue<T> getConfigValue() {
        return this.configValue;
    }

    public ArgumentType<T> getArgumentType() {
        return this.argumentType;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public RequiredArgumentBuilder<CommandSource, T> createArgument() {
        return Commands.func_197056_a((String)this.getArgumentName(), this.getArgumentType());
    }

    public T getArgument(CommandContext<?> context) {
        return (T)context.getArgument(this.getArgumentName(), this.getValueClass());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getArgumentName() {
        return "value";
    }
}

