/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.config;

import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.Map;
import java.util.function.Supplier;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.network.NetworkHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;

public class ConfigSynchronizer {
    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.func_71278_l() && config.getSpec() == HourglassConfig.SERVER_CONFIG.spec) {
            ConfigSynchronizer.syncConfigWithClients();
        }
    }

    public static Class<FMLHandshakeMessages.S2CConfigData> getMessageClass() {
        return FMLHandshakeMessages.S2CConfigData.class;
    }

    public static void encode(FMLHandshakeMessages.S2CConfigData config, PacketBuffer buffer) {
        buffer.func_180714_a(config.getFileName());
        buffer.func_179250_a(config.getBytes());
    }

    public static FMLHandshakeMessages.S2CConfigData decode(PacketBuffer buffer) {
        return FMLHandshakeMessages.S2CConfigData.decode((PacketBuffer)buffer);
    }

    public static void handle(FMLHandshakeMessages.S2CConfigData configData, Supplier<NetworkEvent.Context> context) {
        ConfigTracker.INSTANCE.receiveSyncedConfig(configData, context);
        context.get().setPacketHandled(true);
    }

    public static void syncConfigWithClients() {
        LogManager.getLogger().info("Synchronizing server config with clients.");
        try {
            Field configsByModField = ConfigTracker.class.getDeclaredField("configsByMod");
            configsByModField.setAccessible(true);
            ConfigTracker configTracker = ConfigTracker.INSTANCE;
            ModConfig modConfig = (ModConfig)((Map)((Map)configsByModField.get(configTracker)).get("hourglass")).get(ModConfig.Type.SERVER);
            byte[] configData = Files.readAllBytes(modConfig.getFullPath());
            FMLHandshakeMessages.S2CConfigData message = new FMLHandshakeMessages.S2CConfigData(modConfig.getFileName(), configData);
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
        catch (Exception e) {
            LogManager.getLogger().error("Failed to sync server config with clients.", (Throwable)e);
        }
    }
}

