/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.message;

import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.message.TemplateMessage;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.TimeService;
import net.lavabucket.hourglass.time.TimeServiceManager;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ChatType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HourglassMessages {
    @SubscribeEvent
    public static void onSleepingCheckEvent(SleepingTimeCheckEvent event) {
        TimeService service = TimeServiceManager.service;
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && event.getPlayer().func_71060_bI() == 2 && event.getPlayer().getClass() == ServerPlayerWrapper.playerClass && service != null && ((ServerWorld)service.level.get()).equals(event.getPlayer().field_70170_p) && ((ServerWorld)service.level.get()).func_217369_A().size() > 1 && service.level.daylightRuleEnabled()) {
            HourglassMessages.sendEnterBedMessage(new ServerPlayerWrapper(event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        TimeService service = TimeServiceManager.service;
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && event.updateWorld() && event.getPlayer().getClass() == ServerPlayerWrapper.playerClass && service != null && ((ServerWorld)service.level.get()).equals(event.getPlayer().field_70170_p) && ((ServerWorld)service.level.get()).func_217369_A().size() > 1 && service.level.daylightRuleEnabled()) {
            HourglassMessages.sendLeaveBedMessage(new ServerPlayerWrapper(event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void onSleepFinishedEvent(SleepFinishedTimeEvent event) {
        TimeService service = TimeServiceManager.service;
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && service != null && ((ServerWorld)service.level.get()).equals(event.getWorld()) && service.level.daylightRuleEnabled()) {
            ServerLevelWrapper level = new ServerLevelWrapper(event.getWorld());
            HourglassMessages.sendMorningMessage(level);
        }
    }

    public static void sendEnterBedMessage(ServerPlayerWrapper player) {
        String templateMessage = (String)HourglassConfig.SERVER_CONFIG.enterBedMessage.get();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setType((ChatType)HourglassConfig.SERVER_CONFIG.enterBedMessageType.get()).setVariable("player", ((ServerPlayerEntity)player.get()).func_146103_bH().getName()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.amountSleeping())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send((TemplateMessage.MessageTarget)((Object)HourglassConfig.SERVER_CONFIG.enterBedMessageTarget.get()), player.getLevel());
    }

    public static void sendLeaveBedMessage(ServerPlayerWrapper player) {
        String templateMessage = (String)HourglassConfig.SERVER_CONFIG.leaveBedMessage.get();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setType((ChatType)HourglassConfig.SERVER_CONFIG.leaveBedMessageType.get()).setVariable("player", ((ServerPlayerEntity)player.get()).func_146103_bH().getName()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.amountSleeping() - 1)).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send((TemplateMessage.MessageTarget)((Object)HourglassConfig.SERVER_CONFIG.leaveBedMessageTarget.get()), player.getLevel());
    }

    public static void sendMorningMessage(ServerLevelWrapper level) {
        String templateMessage = (String)HourglassConfig.SERVER_CONFIG.morningMessage.get();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setType((ChatType)HourglassConfig.SERVER_CONFIG.morningMessageType.get()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.amountSleeping())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send((TemplateMessage.MessageTarget)((Object)HourglassConfig.SERVER_CONFIG.morningMessageTarget.get()), level);
    }
}

