/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.message;

import java.util.HashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class TemplateMessage {
    public HashMap<String, String> variables;
    public StrSubstitutor substitutor;
    private ChatType type = ChatType.SYSTEM;
    private TextWrapper message;
    private String template = "";

    public TemplateMessage() {
        this.variables = new HashMap();
        this.substitutor = new StrSubstitutor();
    }

    public ChatType getType() {
        return this.type;
    }

    public TemplateMessage setType(ChatType type) {
        this.type = type;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public TemplateMessage setTemplate(String template) {
        this.template = template;
        return this;
    }

    public TemplateMessage setVariable(String key, String value) {
        this.variables.put(key, value);
        return this;
    }

    public TextWrapper getMessage() {
        return this.message;
    }

    public TemplateMessage bake() {
        this.substitutor.setVariableResolver((StrLookup)new MapLookup(this.variables));
        this.message = TextWrapper.literal(this.substitutor.replace(this.template));
        return this;
    }

    public void send(MessageTarget target) {
        this.send(target, null);
    }

    public void send(MessageTarget target, @Nullable ServerLevelWrapper level) {
        if (target != MessageTarget.ALL && level == null) {
            throw new IllegalArgumentException("Level must be specified unless target is MessageTarget.ALL.");
        }
        if (target == MessageTarget.ALL) {
            ((ServerWorld)level.get()).func_73046_m().func_184103_al().func_232641_a_((ITextComponent)this.message.get(), this.type, Util.field_240973_b_);
        } else {
            Stream<ServerPlayerWrapper> playerStream = ((ServerWorld)level.get()).func_217369_A().stream().map(player -> new ServerPlayerWrapper((PlayerEntity)player));
            if (target == MessageTarget.SLEEPING) {
                playerStream = playerStream.filter(ServerPlayerWrapper::isSleeping);
            }
            playerStream.forEach(player -> ((ServerPlayerEntity)player.get()).func_241151_a_((ITextComponent)this.message.get(), this.type, Util.field_240973_b_));
        }
    }

    public static enum MessageTarget {
        ALL,
        DIMENSION,
        SLEEPING;

    }
}

