/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time;

import java.util.Collection;
import net.lavabucket.hourglass.Hourglass;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.registry.HourglassRegistry;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.Time;
import net.lavabucket.hourglass.time.TimeContext;
import net.lavabucket.hourglass.time.effects.TimeEffect;
import net.lavabucket.hourglass.utils.MathUtils;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.TimePacketWrapper;
import net.minecraft.network.IPacket;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeService {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Time DAY_START = new Time(23500L);
    public static final Time NIGHT_START = new Time(12500L);
    private static final int OVERFLOW_THRESHOLD = 2147328000;
    public final ServerLevelWrapper level;
    public final SleepStatus sleepStatus;
    private double timeDecimalAccumulator = 0.0;

    public TimeService(ServerLevelWrapper level) {
        this.level = level;
        this.sleepStatus = new SleepStatus(() -> (Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get());
        this.level.setSleepStatus(this.sleepStatus);
    }

    public void tick() {
        if (!this.level.daylightRuleEnabled()) {
            return;
        }
        this.sleepStatus.updatePlayerCounts(((ServerWorld)this.level.get()).func_217369_A());
        Time oldTime = this.getDayTime();
        Time deltaTime = this.tickTime();
        Time time = this.getDayTime();
        TimeContext context = new TimeContext(this, time, deltaTime);
        this.getActiveTimeEffects().forEach(effect -> effect.onTimeTick(context));
        if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue()) {
            this.level.preventVanillaSleep();
            if (!this.sleepStatus.allAwake() && Time.crossedMorning(oldTime, time)) {
                this.handleMorning();
            }
        }
        this.preventTimeOverflow();
        this.broadcastTime();
        this.vanillaTimeCompensation();
    }

    private void handleMorning() {
        long time = ((ServerWorld)this.level.get()).func_72820_D();
        ForgeEventFactory.onSleepFinished((ServerWorld)((ServerWorld)this.level.get()), (long)time, (long)time);
        this.sleepStatus.removeAllSleepers();
        this.level.wakeUpAllPlayers();
        if (this.level.weatherRuleEnabled() && ((Boolean)HourglassConfig.SERVER_CONFIG.clearWeatherOnWake.get()).booleanValue()) {
            this.level.stopWeather();
        }
        LOGGER.debug(Hourglass.MARKER, "Sleep cycle complete on dimension: {}.", (Object)((ServerWorld)this.level.get()).func_234923_W_().func_240901_a_());
    }

    private void vanillaTimeCompensation() {
        ((ServerWorld)this.level.get()).func_241114_a_(((ServerWorld)this.level.get()).func_72820_D() - 1L);
    }

    private void preventTimeOverflow() {
        long time = ((ServerWorld)this.level.get()).func_72820_D();
        if (time > 2147328000L) {
            ((ServerWorld)this.level.get()).func_241114_a_(time - 2147328000L);
        }
    }

    private Time tickTime() {
        Time time = this.getDayTime();
        Time timeDelta = new Time(this.getTimeSpeed(time));
        timeDelta = this.correctForOvershoot(time, timeDelta);
        this.setDayTime(time.add(timeDelta));
        return timeDelta;
    }

    private Time correctForOvershoot(Time time, Time timeDelta) {
        Time nextTime = time.add(timeDelta);
        Time timeOfDay = time.timeOfDay();
        Time nextTimeOfDay = nextTime.timeOfDay();
        if (this.sleepStatus.allAwake()) {
            if (NIGHT_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = NIGHT_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
            if (DAY_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = DAY_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
        } else {
            Time timeUntilMorning = Time.DAY_LENGTH.subtract(timeOfDay);
            if (timeUntilMorning.compareTo(timeDelta) < 0) {
                double nextTimeSpeed = (Double)HourglassConfig.SERVER_CONFIG.daySpeed.get();
                double breakpointRatio = 1.0 - timeUntilMorning.divide(timeDelta);
                return timeUntilMorning.add(nextTimeSpeed * breakpointRatio);
            }
        }
        return timeDelta;
    }

    public double getTimeSpeed(Time time) {
        if (!((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() || this.sleepStatus.allAwake()) {
            if (time.equals(DAY_START) || time.timeOfDay().betweenMod(DAY_START, NIGHT_START)) {
                return (Double)HourglassConfig.SERVER_CONFIG.daySpeed.get();
            }
            return (Double)HourglassConfig.SERVER_CONFIG.nightSpeed.get();
        }
        if (this.sleepStatus.allAsleep() && (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedAll.get() >= 0.0) {
            return (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedAll.get();
        }
        double sleepRatio = this.sleepStatus.ratio();
        double curve = (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedCurve.get();
        double speedRatio = MathUtils.normalizedTunableSigmoid(sleepRatio, curve);
        double sleepSpeedMin = (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedMin.get();
        double sleepSpeedMax = (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedMax.get();
        double multiplier = MathUtils.lerp(speedRatio, sleepSpeedMin, sleepSpeedMax);
        return multiplier;
    }

    public Time getDayTime() {
        return new Time(((ServerWorld)this.level.get()).func_72820_D(), this.timeDecimalAccumulator);
    }

    public Time setDayTime(Time time) {
        this.timeDecimalAccumulator = time.fractionalValue();
        ((ServerWorld)this.level.get()).func_241114_a_(time.longValue());
        return time;
    }

    public void broadcastTime() {
        TimePacketWrapper timePacket = TimePacketWrapper.create(this.level);
        ((ServerWorld)this.level.get()).func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.managesLevel(new ServerLevelWrapper((IWorld)player.field_70170_p))).forEach(player -> player.field_71135_a.func_147359_a((IPacket)timePacket.get()));
    }

    public boolean managesLevel(ServerLevelWrapper levelToCheck) {
        if (((ServerWorld)this.level.get()).equals(levelToCheck.get())) {
            return true;
        }
        return ((ServerWorld)this.level.get()).equals(((ServerWorld)this.level.get()).func_73046_m().func_241755_D_()) && ServerLevelWrapper.isDerived((IWorld)levelToCheck.get());
    }

    private Collection<TimeEffect> getActiveTimeEffects() {
        return HourglassRegistry.TIME_EFFECT.getValues();
    }
}

