/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.wrappers;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.lavabucket.hourglass.Hourglass;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.lavabucket.hourglass.wrappers.Wrapper;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerLevelWrapper
extends Wrapper<ServerWorld> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Class<ServerWorld> levelClass = ServerWorld.class;
    private static final Class<IServerWorldInfo> levelDataClass = IServerWorldInfo.class;
    private static final Class<DerivedWorldInfo> derivedLevelDataClass = DerivedWorldInfo.class;
    public final IServerWorldInfo levelData = levelDataClass.cast(((ServerWorld)this.get()).func_72912_H());

    public ServerLevelWrapper(IWorld level) {
        super(levelClass.cast(level));
    }

    public boolean daylightRuleEnabled() {
        return ((ServerWorld)this.get()).func_82736_K().func_223586_b(GameRules.field_223607_j);
    }

    public boolean weatherRuleEnabled() {
        return ((ServerWorld)this.get()).func_82736_K().func_223586_b(GameRules.field_223617_t);
    }

    public void setRandomTickSpeed(int speed) {
        CommandSource commandSource = new CommandSource(null, null, null, null, 0, null, null, ((ServerWorld)this.get()).func_73046_m(), null);
        HashMap<String, ParsedArgument> arguments = new HashMap<String, ParsedArgument>();
        arguments.put("value", new ParsedArgument(0, 0, (Object)speed));
        CommandContext commandContext = new CommandContext((Object)commandSource, null, arguments, null, null, null, null, null, null, false);
        ((GameRules.IntegerValue)((ServerWorld)this.get()).func_82736_K().func_223585_a(GameRules.field_223610_m)).func_223554_b(commandContext, "value");
    }

    public boolean weatherCycleEnabled() {
        return this.weatherRuleEnabled() && ((ServerWorld)this.get()).func_230315_m_().func_218272_d();
    }

    public void stopWeather() {
        this.levelData.func_76080_g(0);
        this.levelData.func_76084_b(false);
        this.levelData.func_76090_f(0);
        this.levelData.func_76069_a(false);
    }

    public void setSleepStatus(SleepStatus newStatus) {
    }

    public void preventVanillaSleep() {
        try {
            Field allPlayersSleeping = ObfuscationReflectionHelper.findField(ServerWorld.class, (String)"field_73068_P");
            allPlayersSleeping.setAccessible(true);
            allPlayersSleeping.setBoolean(this.get(), false);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            LogManager.getLogger().warn(Hourglass.MARKER, "Error preventing vanilla sleep - could not access ServerWorld#allPlayersSleeping field.");
        }
    }

    public void wakeUpAllPlayers() {
        ((ServerWorld)this.get()).func_217369_A().stream().map(player -> new ServerPlayerWrapper((PlayerEntity)player)).filter(ServerPlayerWrapper::isSleeping).forEach(player -> ((ServerPlayerEntity)player.get()).func_225652_a_(false, false));
    }

    public void tickBlockEntities() {
        try {
            Method tickBlockEntitiesMethod = ObfuscationReflectionHelper.findMethod(World.class, (String)"func_217391_K", (Class[])new Class[0]);
            tickBlockEntitiesMethod.setAccessible(true);
            tickBlockEntitiesMethod.invoke(this.get(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException | ObfuscationReflectionHelper.UnableToFindMethodException e) {
            LOGGER.warn(Hourglass.MARKER, "Error ticking block entities.", e);
            return;
        }
    }

    public static boolean isDerived(IWorld level) {
        return level != null && level.func_72912_H().getClass() == derivedLevelDataClass;
    }

    public static boolean isServerLevel(IWorld level) {
        return level != null && level.getClass() == levelClass;
    }
}

