/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fmlclient.ConfigGuiHandler;

public final class ConfigScreen
extends Screen {
    private static final int TITLE_MARGIN = 8;
    private static final int OPTIONS_LIST_MARGIN = 24;
    private static final int OPTIONS_LIST_BOTTOM_MARGIN = 32;
    private static final int OPTION_HEIGHT = 25;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int DONE_BUTTON_BOTTOM_MARGIN = 6;
    private static final String KEY_TITLE = "hourglass.configgui.title";
    private static final String KEY_CLOCK_ALIGNMENT = "hourglass.configgui.clockAlignment";
    private static final String KEY_CLOCK_SCALE = "hourglass.configgui.clockScale";
    private static final String KEY_CLOCK_MARGIN = "hourglass.configgui.clockMargin";
    private static final String KEY_PREVENT_CLOCK_WOBBLE = "hourglass.configgui.preventClockWobble";
    private static final String KEY_PIXELS = "hourglass.configgui.pixels";
    private static final String KEY_DONE = "gui.done";
    private static final String KEY_GENERIC_OPTION = "options.generic_value";
    protected Screen lastScreen;
    protected OptionsList optionsList;
    protected Button doneButton;
    private ScreenAlignment clockAlignment;
    private int clockScale;
    private int clockMargin;
    private boolean preventClockWobble;

    @SubscribeEvent
    public static void onConstructModEvent(FMLConstructModEvent event) {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new ConfigScreen((Screen)screen)));
    }

    public ConfigScreen(Screen lastScreen) {
        super((Component)TextWrapper.translation(KEY_TITLE).get());
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        this.fetchSettings();
        this.optionsList = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 24, this.f_96544_ - 32, 25);
        this.optionsList.m_94471_((Option)CycleOption.m_167737_((String)KEY_CLOCK_ALIGNMENT, Arrays.asList(ScreenAlignment.values()), value -> (Component)TextWrapper.translation(value.getKey()).get(), options -> this.clockAlignment, (options, option, value) -> {
            this.clockAlignment = value;
        }));
        this.optionsList.m_94471_((Option)new ProgressOption(KEY_CLOCK_SCALE, 0.0, 128.0, 4.0f, settings -> this.clockScale, (settings, value) -> {
            this.clockScale = value.intValue();
        }, (settings, option) -> (Component)ConfigScreen.pixelOptionText(KEY_CLOCK_SCALE, option.m_92221_(settings)).get()));
        this.optionsList.m_94471_((Option)new ProgressOption(KEY_CLOCK_MARGIN, 0.0, 128.0, 4.0f, settings -> this.clockMargin, (settings, value) -> {
            this.clockMargin = value.intValue();
        }, (settings, option) -> (Component)ConfigScreen.pixelOptionText(KEY_CLOCK_MARGIN, option.m_92221_(settings)).get()));
        this.optionsList.m_94471_((Option)CycleOption.m_167743_((String)KEY_PREVENT_CLOCK_WOBBLE, settings -> this.preventClockWobble, (options, option, value) -> {
            this.preventClockWobble = value;
        }));
        this.m_7787_((GuiEventListener)this.optionsList);
        int doneX = (this.f_96543_ - 200) / 2;
        int doneY = this.f_96544_ - 20 - 6;
        TextWrapper doneText = TextWrapper.translation(KEY_DONE);
        this.doneButton = new Button(doneX, doneY, 200, 20, (Component)doneText.get(), button -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.doneButton);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.optionsList.m_6305_(stack, mouseX, mouseY, partialTicks);
        ConfigScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.saveSettings();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    private void fetchSettings() {
        this.clockAlignment = (ScreenAlignment)((Object)HourglassConfig.CLIENT_CONFIG.clockAlignment.get());
        this.clockScale = (Integer)HourglassConfig.CLIENT_CONFIG.clockScale.get();
        this.clockMargin = (Integer)HourglassConfig.CLIENT_CONFIG.clockMargin.get();
        this.preventClockWobble = (Boolean)HourglassConfig.CLIENT_CONFIG.preventClockWobble.get();
    }

    private void saveSettings() {
        HourglassConfig.CLIENT_CONFIG.clockAlignment.set((Object)this.clockAlignment);
        HourglassConfig.CLIENT_CONFIG.clockScale.set((Object)this.clockScale);
        HourglassConfig.CLIENT_CONFIG.clockMargin.set((Object)this.clockMargin);
        HourglassConfig.CLIENT_CONFIG.preventClockWobble.set((Object)this.preventClockWobble);
    }

    public static TextWrapper pixelOptionText(String key, double pixelCount) {
        return TextWrapper.translation(KEY_GENERIC_OPTION, TextWrapper.translation(key).get(), TextWrapper.translation(KEY_PIXELS, (int)pixelCount).get());
    }
}

