/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.config;

import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.Map;
import java.util.function.Supplier;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.network.NetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fmllegacy.network.ConfigSync;
import net.minecraftforge.fmllegacy.network.FMLHandshakeMessages;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;

public class ConfigSynchronizer {
    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.m_130010_() && config.getSpec() == HourglassConfig.SERVER_CONFIG.spec) {
            ConfigSynchronizer.syncConfigWithClients();
        }
    }

    public static Class<FMLHandshakeMessages.S2CConfigData> getMessageClass() {
        return FMLHandshakeMessages.S2CConfigData.class;
    }

    public static void encode(FMLHandshakeMessages.S2CConfigData config, FriendlyByteBuf buffer) {
        buffer.m_130070_(config.getFileName());
        buffer.m_130087_(config.getBytes());
    }

    public static FMLHandshakeMessages.S2CConfigData decode(FriendlyByteBuf buffer) {
        return FMLHandshakeMessages.S2CConfigData.decode((FriendlyByteBuf)buffer);
    }

    public static void handle(FMLHandshakeMessages.S2CConfigData configData, Supplier<NetworkEvent.Context> context) {
        ConfigSync.INSTANCE.receiveSyncedConfig(configData, context);
        context.get().setPacketHandled(true);
    }

    public static void syncConfigWithClients() {
        LogManager.getLogger().info("Synchronizing server config with clients.");
        try {
            Field configsByModField = ConfigTracker.class.getDeclaredField("configsByMod");
            configsByModField.setAccessible(true);
            ConfigTracker configTracker = ConfigTracker.INSTANCE;
            ModConfig modConfig = (ModConfig)((Map)((Map)configsByModField.get(configTracker)).get("hourglass")).get(ModConfig.Type.SERVER);
            byte[] configData = Files.readAllBytes(modConfig.getFullPath());
            FMLHandshakeMessages.S2CConfigData message = new FMLHandshakeMessages.S2CConfigData(modConfig.getFileName(), configData);
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
        catch (Exception e) {
            LogManager.getLogger().error("Failed to sync server config with clients.", (Throwable)e);
        }
    }
}

