/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time;

import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.Time;
import net.lavabucket.hourglass.time.TimeService;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class TimeServiceManager {
    public static TimeService service;
    public static final Time VANILLA_SLEEP_END;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDaySleepCheck(SleepingTimeCheckEvent event) {
        if (service != null && ((ServerLevel)TimeServiceManager.service.level.get()).equals(event.getPlayer().f_19853_) && ((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && ((Boolean)HourglassConfig.SERVER_CONFIG.allowDaySleep.get()).booleanValue()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onSleepingCheckEvent(SleepingTimeCheckEvent event) {
        if (service != null && ((ServerLevel)TimeServiceManager.service.level.get()).equals(event.getPlayer().f_19853_)) {
            Time time = service.getDayTime().timeOfDay();
            if (((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() && time.compareTo(VANILLA_SLEEP_END) >= 0) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        ServerLevelWrapper level;
        if (ServerLevelWrapper.isServerLevel(event.getWorld()) && ((ServerLevel)(level = new ServerLevelWrapper(event.getWorld())).get()).equals(((ServerLevel)level.get()).m_142572_().m_129783_())) {
            service = new TimeService(level);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (service != null && TimeServiceManager.service.level.get() == event.getWorld()) {
            service = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && service != null && TimeServiceManager.service.level.get() == event.world) {
            service.tick();
        }
    }

    static {
        VANILLA_SLEEP_END = new Time(23460L);
    }
}

