/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.lavabucket.hourglass.command.config.ConfigCommand;
import net.lavabucket.hourglass.command.config.ConfigCommandEntry;
import net.lavabucket.hourglass.config.ConfigSynchronizer;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.TimeService;
import net.lavabucket.hourglass.time.TimeServiceManager;
import net.lavabucket.hourglass.time.effects.EffectCondition;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HourglassCommand {
    private static final DoubleArgumentType TIME_SPEED_ARGUMENT = DoubleArgumentType.doubleArg((double)0.0, (double)24000.0);

    @SubscribeEvent
    public static void onRegisterCommandEvent(RegisterCommandsEvent event) {
        ConfigCommand configCommand = new ConfigCommand().setQuerySuccessHandler(HourglassCommand::onQuerySuccess).setModifySuccessHandler(HourglassCommand::onModifySuccess).setModifyFailureHandler(HourglassCommand::onModifyFailure).register(HourglassConfig.SERVER_CONFIG.daySpeed, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.nightSpeed, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.enableSleepFeature).register(HourglassConfig.SERVER_CONFIG.sleepSpeedMin, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.sleepSpeedMax, (ArgumentType<Double>)TIME_SPEED_ARGUMENT).register(HourglassConfig.SERVER_CONFIG.sleepSpeedAll, (ArgumentType<Double>)DoubleArgumentType.doubleArg((double)-1.0, (double)24000.0)).register(HourglassConfig.SERVER_CONFIG.sleepSpeedCurve, (ArgumentType<Double>)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).register(HourglassConfig.SERVER_CONFIG.clearWeatherOnWake).register(HourglassConfig.SERVER_CONFIG.displayBedClock).register(HourglassConfig.SERVER_CONFIG.allowDaySleep).register(HourglassConfig.SERVER_CONFIG.weatherEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.randomTickEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.baseRandomTickSpeed, (ArgumentType<Integer>)IntegerArgumentType.integer((int)0)).register(HourglassConfig.SERVER_CONFIG.potionEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.hungerEffect, EffectCondition.class).register(HourglassConfig.SERVER_CONFIG.blockEntityEffect, EffectCondition.class);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hourglass").requires(source -> source.m_6761_(2))).then(configCommand.build((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_((String)"config")))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"query").then(Commands.m_82127_((String)"timeSpeed").executes(HourglassCommand::onTimeSpeedQuery))).then(Commands.m_82127_((String)"sleeperCount").executes(HourglassCommand::onSleeperCountQuery))));
    }

    public static <T> void onQuerySuccess(CommandContext<CommandSourceStack> context, ConfigCommandEntry<T> entry) {
        TextWrapper response = TextWrapper.translation("commands.hourglass.config.query", entry.getIdentifier(), entry.getConfigValue().get().toString());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)response.get(), false);
    }

    public static <T> void onModifySuccess(CommandContext<CommandSourceStack> context, ConfigCommandEntry<T> entry) {
        ConfigSynchronizer.syncConfigWithClients();
        TextWrapper response = TextWrapper.translation("commands.hourglass.config.set", entry.getIdentifier(), entry.getConfigValue().get());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)response.get(), true);
    }

    public static <T> void onModifyFailure(CommandContext<CommandSourceStack> context, ConfigCommandEntry<T> entry) {
        TextWrapper response = TextWrapper.translation("commands.hourglass.config.failure", entry.getIdentifier(), entry.getConfigValue().get());
        ((CommandSourceStack)context.getSource()).m_81352_((Component)response.get());
    }

    public static int onTimeSpeedQuery(CommandContext<CommandSourceStack> context) {
        ServerLevelWrapper wrapper = new ServerLevelWrapper((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_());
        TimeService service = TimeServiceManager.service;
        if (service == null || !service.managesLevel(wrapper)) {
            TextWrapper response = TextWrapper.translation("commands.hourglass.query.levelNotApplicable");
            ((CommandSourceStack)context.getSource()).m_81352_((Component)response.get());
            return 0;
        }
        TextWrapper response = TextWrapper.translation("commands.hourglass.query.timeSpeed.success", service.getTimeSpeed(service.getDayTime()));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)response.get(), false);
        return 1;
    }

    public static int onSleeperCountQuery(CommandContext<CommandSourceStack> context) {
        ServerLevelWrapper wrapper = new ServerLevelWrapper((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_());
        TimeService service = TimeServiceManager.service;
        if (service == null || !service.managesLevel(wrapper)) {
            TextWrapper response = TextWrapper.translation("commands.hourglass.query.levelNotApplicable");
            ((CommandSourceStack)context.getSource()).m_81352_((Component)response.get());
            return 0;
        }
        TextWrapper response = TextWrapper.translation("commands.hourglass.query.sleeperCount.success", service.sleepStatus.percentage(), service.sleepStatus.m_144009_(), service.sleepStatus.amountActive());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)response.get(), false);
        return 1;
    }
}

