/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.message;

import java.util.HashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class TemplateMessage {
    public HashMap<String, String> variables;
    public StrSubstitutor substitutor;
    private ChatType type = ChatType.SYSTEM;
    private TextWrapper message;
    private String template = "";

    public TemplateMessage() {
        this.variables = new HashMap();
        this.substitutor = new StrSubstitutor();
    }

    public ChatType getType() {
        return this.type;
    }

    public TemplateMessage setType(ChatType type) {
        this.type = type;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public TemplateMessage setTemplate(String template) {
        this.template = template;
        return this;
    }

    public TemplateMessage setVariable(String key, String value) {
        this.variables.put(key, value);
        return this;
    }

    public TextWrapper getMessage() {
        return this.message;
    }

    public TemplateMessage bake() {
        this.substitutor.setVariableResolver((StrLookup)new MapLookup(this.variables));
        this.message = TextWrapper.literal(this.substitutor.replace(this.template));
        return this;
    }

    public void send(MessageTarget target) {
        this.send(target, null);
    }

    public void send(MessageTarget target, @Nullable ServerLevelWrapper level) {
        if (target != MessageTarget.ALL && level == null) {
            throw new IllegalArgumentException("Level must be specified unless target is MessageTarget.ALL.");
        }
        if (target == MessageTarget.ALL) {
            ((ServerLevel)level.get()).m_142572_().m_6846_().m_11264_((Component)this.message.get(), this.type, Util.f_137441_);
        } else {
            Stream<ServerPlayerWrapper> playerStream = ((ServerLevel)level.get()).m_6907_().stream().map(player -> new ServerPlayerWrapper((Player)player));
            if (target == MessageTarget.SLEEPING) {
                playerStream = playerStream.filter(ServerPlayerWrapper::isSleeping);
            }
            playerStream.forEach(player -> ((ServerPlayer)player.get()).m_9146_((Component)this.message.get(), this.type, Util.f_137441_));
        }
    }

    public static enum MessageTarget {
        ALL,
        DIMENSION,
        SLEEPING;

    }
}

