/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.registry;

import java.util.function.Supplier;
import net.lavabucket.hourglass.time.effects.BlockEntityTimeEffect;
import net.lavabucket.hourglass.time.effects.HungerTimeEffect;
import net.lavabucket.hourglass.time.effects.PotionTimeEffect;
import net.lavabucket.hourglass.time.effects.RandomTickSleepEffect;
import net.lavabucket.hourglass.time.effects.TimeEffect;
import net.lavabucket.hourglass.time.effects.WeatherSleepEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class TimeEffects {
    public static final ResourceLocation KEY = new ResourceLocation("hourglass", "time_effect");
    private static final DeferredRegister<TimeEffect> DEFERRED_REGISTRY = DeferredRegister.create((ResourceLocation)KEY, (String)"hourglass");
    public static final Supplier<IForgeRegistry<TimeEffect>> REGISTRY = DEFERRED_REGISTRY.makeRegistry(TimeEffect.class, RegistryBuilder::new);
    public static final RegistryObject<TimeEffect> WEATHER_EFFECT = DEFERRED_REGISTRY.register("weather", WeatherSleepEffect::new);
    public static final RegistryObject<TimeEffect> RANDOM_TICK_EFFECT = DEFERRED_REGISTRY.register("random_tick", RandomTickSleepEffect::new);
    public static final RegistryObject<TimeEffect> POTION_EFFECT = DEFERRED_REGISTRY.register("potion", PotionTimeEffect::new);
    public static final RegistryObject<TimeEffect> HUNGER_EFFECT = DEFERRED_REGISTRY.register("hunger", HungerTimeEffect::new);
    public static final RegistryObject<TimeEffect> BLOCK_ENTITY_EFFECT = DEFERRED_REGISTRY.register("block_entity", BlockEntityTimeEffect::new);

    @SubscribeEvent
    public static void onConstructModEvent(FMLConstructModEvent event) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEFERRED_REGISTRY.register(modBus);
    }

    private TimeEffects() {
    }
}

