/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time;

import java.util.List;
import java.util.function.Supplier;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.minecraft.server.level.ServerPlayer;

public class SleepStatus
extends net.minecraft.server.players.SleepStatus {
    protected int activePlayerCount;
    protected int sleepingPlayerCount;
    protected Supplier<Boolean> preventSleepSupplier;

    public SleepStatus(Supplier<Boolean> preventSleepSupplier) {
        this.preventSleepSupplier = preventSleepSupplier;
    }

    public void m_144001_() {
        this.sleepingPlayerCount = 0;
    }

    public int m_144009_() {
        return this.sleepingPlayerCount;
    }

    public int amountActive() {
        return this.activePlayerCount;
    }

    public boolean allAwake() {
        return this.sleepingPlayerCount == 0;
    }

    public boolean allAsleep() {
        return this.sleepingPlayerCount == this.activePlayerCount;
    }

    public double ratio() {
        return (double)this.sleepingPlayerCount / (double)this.activePlayerCount;
    }

    public int percentage() {
        return (int)(this.ratio() * 100.0);
    }

    public void updatePlayerCounts(List<ServerPlayer> playerList) {
        this.activePlayerCount = 0;
        this.sleepingPlayerCount = 0;
        for (ServerPlayer player : playerList) {
            if (player.m_5833_()) continue;
            ++this.activePlayerCount;
            if (!player.m_5803_()) continue;
            ++this.sleepingPlayerCount;
        }
    }

    public int m_144010_(int percentageRequired) {
        return Math.max(1, (int)Math.ceil((double)(this.activePlayerCount * percentageRequired) / 100.0));
    }

    public boolean m_144002_(int percentageRequired) {
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        return this.sleepingPlayerCount >= this.m_144010_(percentageRequired);
    }

    public boolean m_144004_(int percentageRequired, List<ServerPlayer> playerList) {
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        long deepSleepers = playerList.stream().map(ServerPlayerWrapper::new).filter(ServerPlayerWrapper::isSleepingLongEnough).count();
        return deepSleepers >= (long)this.m_144010_(percentageRequired);
    }

    public boolean m_144007_(List<ServerPlayer> playerList) {
        int oldActiveCount = this.activePlayerCount;
        int oldSleepingCount = this.sleepingPlayerCount;
        this.updatePlayerCounts(playerList);
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        boolean noSleepers = oldSleepingCount == 0 && this.sleepingPlayerCount == 0;
        boolean valueChanged = oldActiveCount != this.activePlayerCount || oldSleepingCount != this.sleepingPlayerCount;
        return !noSleepers && valueChanged;
    }
}

