/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.lava_walker;

import com.github.mikn.lava_walker.block.ModdedObsidian;
import com.github.mikn.lava_walker.config.LavaWalkerConfig;
import com.github.mikn.lava_walker.enchantment.LavaWalkerEnchantment;
import com.github.mikn.lava_walker.event.OnEntityUpdateEvent;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="lava_walker", updateJSON="https://raw.githubusercontent.com/MitsukiGoto/LavaWalkerMod/1.12.2/versions/versions.json")
public class LavaWalker {
    public static final String MODID = "lava_walker";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/MitsukiGoto/LavaWalkerMod/1.12.2/versions/versions.json";
    public static final Logger LOGGER = LogManager.getLogger((String)"LavaWalker/Main");
    public static final Enchantment LAVA_WALKER = new LavaWalkerEnchantment(Enchantment.Rarity.RARE, EntityEquipmentSlot.FEET);
    public static final Block MODDED_OBSIDIAN = new ModdedObsidian();

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)LAVA_WALKER);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)MODDED_OBSIDIAN);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)((Item)new ItemBlock(MODDED_OBSIDIAN).setRegistryName(MODDED_OBSIDIAN.getRegistryName())).func_77655_b("modded_obsidian"));
    }

    @SubscribeEvent
    public void updateCheck(PlayerEvent.PlayerLoggedInEvent evt) {
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(MODID);
        ForgeVersion.Status status = ForgeVersion.getResult((ModContainer)container).status;
        LOGGER.info((Object)status);
        if (status == ForgeVersion.Status.OUTDATED) {
            evt.player.func_145747_a((ITextComponent)new TextComponentString("LavaWalker Mod: New Version Available!"));
        }
    }

    @SubscribeEvent
    public void onChangedBlock(OnEntityUpdateEvent evt) {
        int i;
        BlockPos blockPos = evt.getBlockPos();
        EntityLivingBase entityLivingBase = evt.getLivingEntity();
        if (!LavaWalkerConfig.CONFIG_TYPES.affectEnchantment) {
            evt.setCanceled(true);
            return;
        }
        int k = EnchantmentHelper.func_185284_a((Enchantment)LAVA_WALKER, (EntityLivingBase)entityLivingBase);
        if (k > 0) {
            LavaWalkerEnchantment.freezeNearby(entityLivingBase, entityLivingBase.field_70170_p, blockPos, k);
        }
        if ((i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185301_j, (EntityLivingBase)entityLivingBase)) > 0) {
            EnchantmentFrostWalker.func_185266_a((EntityLivingBase)entityLivingBase, (World)entityLivingBase.field_70170_p, (BlockPos)blockPos, (int)i);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent evt) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MODDED_OBSIDIAN), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(MODID, "modded_obsidian"), "inventory"));
    }
}

