/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.lavawalker;

import com.github.mikn.lavawalker.config.LavaWalkerConfig;
import com.github.mikn.lavawalker.enchantment.LavaWalkerEnchantment;
import com.github.mikn.lavawalker.event.OnChangedBlockEvent;
import com.github.mikn.lavawalker.init.BlockInit;
import com.github.mikn.lavawalker.init.EnchantmentInit;
import com.github.mikn.lavawalker.init.ItemInit;
import com.github.mikn.lavawalker.network.Message;
import com.github.mikn.lavawalker.network.Network;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lava_walker")
public class LavaWalker {
    public static final String MODID = "lava_walker";
    public static final Logger LOGGER = LogManager.getLogger((String)"LavaWalker/Main");
    public static KeyBinding[] keyBindings;
    public static ArrayList<UUID> availablePlayers;
    private boolean isEnchantmentAvailable = true;

    public LavaWalker() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, LavaWalkerConfig.SPEC, "lava_walker-common.toml");
        BlockInit.BLOCKS.register(bus);
        ItemInit.ITEMS.register(bus);
        EnchantmentInit.ENCHANTMENTS.register(bus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        keyBindings = new KeyBinding[1];
        LavaWalker.keyBindings[0] = new KeyBinding("Enable/Disable LavaWalker", 74, "LavaWalker");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[0]);
    }

    private void commonSetup(FMLCommonSetupEvent evt) {
        Network.init();
        availablePlayers = new ArrayList();
    }

    @SubscribeEvent
    public void toggleAffect(InputEvent.KeyInputEvent evt) {
        if (keyBindings[0].func_151470_d()) {
            if (this.isEnchantmentAvailable) {
                this.sendClientMessage("LavaWalker Enchantment is unavailable now");
            } else {
                this.sendClientMessage("LavaWalker Enchantment is available now");
            }
            Network.CHANNEL.sendToServer((Object)new Message(1));
            this.isEnchantmentAvailable = !this.isEnchantmentAvailable;
        }
    }

    @SubscribeEvent
    public void updateCheck(PlayerEvent.PlayerLoggedInEvent evt) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(MODID).get();
        VersionChecker.Status status = VersionChecker.getResult((IModInfo)container.getModInfo()).status;
        LOGGER.info((Object)status);
        if (status == VersionChecker.Status.OUTDATED) {
            this.sendClientMessage("LavaWalker Mod: New Version Available!");
        }
    }

    @SubscribeEvent
    public void onChangedBlock(OnChangedBlockEvent evt) {
        BlockPos blockPos = evt.getBlockPos();
        LivingEntity livingEntity = evt.getLivingEntity();
        if (livingEntity instanceof PlayerEntity && !this.isEnchantmentAvailable || availablePlayers.stream().anyMatch(s -> s.equals(livingEntity.func_110124_au()))) {
            int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185301_j, (LivingEntity)livingEntity);
            if (i > 0) {
                FrostWalkerEnchantment.func_185266_a((LivingEntity)livingEntity, (World)livingEntity.field_70170_p, (BlockPos)blockPos, (int)i);
            }
            evt.setCanceled(true);
            return;
        }
        int k = EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)EnchantmentInit.LAVA_WALKER.get()), (LivingEntity)livingEntity);
        if (k > 0) {
            LavaWalkerEnchantment.onEntityMoved(livingEntity, livingEntity.field_70170_p, blockPos, k);
        }
    }

    private void sendClientMessage(String message) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
    }
}

