/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.lavawalker;

import com.github.mikn.lavawalker.config.LavaWalkerConfig;
import com.github.mikn.lavawalker.enchantment.LavaWalkerEnchantment;
import com.github.mikn.lavawalker.event.OnChangedBlockEvent;
import com.github.mikn.lavawalker.init.BlockInit;
import com.github.mikn.lavawalker.init.EnchantmentInit;
import com.github.mikn.lavawalker.init.ItemInit;
import com.github.mikn.lavawalker.network.Message;
import com.github.mikn.lavawalker.network.NetWork;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lava_walker")
public class LavaWalker {
    public static final String MODID = "lava_walker";
    public static final Logger LOGGER = LogManager.getLogger((String)"LavaWalker/Main");
    public static KeyMapping[] keyMappings;
    public static ArrayList<UUID> availablePlayers;
    private boolean isEnchantmentAvailable = true;

    public LavaWalker() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)LavaWalkerConfig.SPEC, "lava_walker-common.toml");
        BlockInit.BLOCKS.register(bus);
        ItemInit.ITEMS.register(bus);
        EnchantmentInit.ENCHANTMENTS.register(bus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        keyMappings = new KeyMapping[1];
        LavaWalker.keyMappings[0] = new KeyMapping("Enable/Disable LavaWalker", 74, "LavaWalker");
        ClientRegistry.registerKeyBinding((KeyMapping)keyMappings[0]);
    }

    private void commonSetup(FMLCommonSetupEvent evt) {
        NetWork.init();
        availablePlayers = new ArrayList();
    }

    @SubscribeEvent
    public void toggleAffect(InputEvent.KeyInputEvent evt) {
        if (keyMappings[0].m_90857_()) {
            if (this.isEnchantmentAvailable) {
                LavaWalker.sendClientMessage("LavaWalker Enchantment is unavailable now");
            } else {
                LavaWalker.sendClientMessage("LavaWalker Enchantment is available now");
            }
            NetWork.CHANNEL.sendToServer((Object)new Message(1));
            this.isEnchantmentAvailable = !this.isEnchantmentAvailable;
        }
    }

    @SubscribeEvent
    public void updateCheck(PlayerEvent.PlayerLoggedInEvent evt) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(MODID).get();
        VersionChecker.Status status = VersionChecker.getResult((IModInfo)container.getModInfo()).status();
        LOGGER.info((Object)status);
        if (status == VersionChecker.Status.OUTDATED) {
            Player player = evt.getPlayer();
            player.m_6352_((Component)new TextComponent("LavaWalker Mod: New Version Available!"), player.m_142081_());
        }
    }

    @SubscribeEvent
    public void onChangedBlock(OnChangedBlockEvent evt) {
        BlockPos blockPos = evt.getBlockPos();
        LivingEntity livingEntity = evt.getLivingEntity();
        if (livingEntity instanceof Player && !this.isEnchantmentAvailable || availablePlayers.stream().anyMatch(s -> s.equals(livingEntity.m_142081_()))) {
            int i = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44974_, (LivingEntity)livingEntity);
            if (i > 0) {
                FrostWalkerEnchantment.m_45018_((LivingEntity)livingEntity, (Level)livingEntity.f_19853_, (BlockPos)blockPos, (int)i);
            }
            evt.setCanceled(true);
            return;
        }
        int k = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentInit.LAVA_WALKER.get()), (LivingEntity)livingEntity);
        if (k > 0) {
            LavaWalkerEnchantment.onEntityMoved(livingEntity, livingEntity.f_19853_, blockPos, k);
        }
    }

    public static void sendClientMessage(String message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.m_6352_((Component)new TextComponent(message), player.m_142081_());
    }
}

