/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium.block;

import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.mehvahdjukaar.randomium.Randomium;
import net.mehvahdjukaar.randomium.configs.CommonConfigs;
import net.mehvahdjukaar.randomium.entity.MovingBlockEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RandomiumOreBlock
extends Block {
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;
    private double total = 0.0;
    private final NavigableMap<Double, Direction> map = new TreeMap<Double, Direction>(){
        {
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.FLY_CHANCE.get()).intValue(), Direction.UP);
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.FALL_CHANCE.get()).intValue(), Direction.DOWN);
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.NORTH);
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.SOUTH);
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.EAST);
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.WEST);
            this.put(RandomiumOreBlock.this.total = RandomiumOreBlock.this.total + (double)((Integer)CommonConfigs.TELEPORT_CHANCE.get()).intValue(), null);
        }
    };

    public RandomiumOreBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return this.getRandomDrops(state, (World)builder.func_216018_a(), (ItemStack)builder.func_216019_b(LootParameters.field_216289_i), (Entity)builder.func_216019_b(LootParameters.field_216281_a));
    }

    public List<ItemStack> getRandomDrops(BlockState state, World world, @Nullable ItemStack tool, @Nullable Entity entity) {
        ItemStack loot;
        double percentage = (Double)CommonConfigs.BASE_DROP_CHANCE.get();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (le.func_70644_a(Effects.field_188425_z)) {
                percentage += (double)le.func_70660_b(Effects.field_188425_z).func_76458_c() * (Double)CommonConfigs.LUCK_MULTIPLIER.get();
            }
            if (le.func_70644_a(Effects.field_189112_A)) {
                percentage -= (double)le.func_70660_b(Effects.field_189112_A).func_76458_c() * (Double)CommonConfigs.LUCK_MULTIPLIER.get();
            }
            if (tool != null) {
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
                percentage += (Double)CommonConfigs.FORTUNE_MULTIPLIER.get() * (double)fortune;
            }
        }
        if ((double)(world.field_73012_v.nextFloat() * 100.0f) <= percentage) {
            loot = new ItemStack((IItemProvider)Randomium.RANDOMIUM_ITEM.get());
        } else if (tool != null && ((Boolean)CommonConfigs.ALLOW_SILK_TOUCH.get()).booleanValue() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) != 0) {
            loot = new ItemStack((IItemProvider)this.func_199767_j());
        } else {
            List<ItemStack> l = Randomium.LOOT.get(world.field_73012_v.nextInt(Randomium.LOOT.size()));
            loot = l.get(world.field_73012_v.nextInt(l.size()));
        }
        return Collections.singletonList(loot);
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? MathHelper.func_76136_a((Random)this.RANDOM, (int)0, (int)6) : 0;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return Randomium.SOUNDS.get(this.RANDOM.nextInt(Randomium.SOUNDS.size()));
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        if (world instanceof World) {
            return (float)Math.max(0.0, ((World)world).field_73012_v.nextGaussian() * 6.0 + 8.0);
        }
        return 6.0f;
    }

    public Random getBlockRandom(BlockPos pos) {
        return new Random(this.getBlockSeed(pos));
    }

    public Long getBlockSeed(BlockPos pos) {
        return MathHelper.func_180186_a((Vector3i)pos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return this.getBlockRandom(pos).nextInt(16);
    }

    public int getGravityType(BlockPos pos) {
        long seed = this.getBlockSeed(pos);
        if (seed % 3L == 0L) {
            return 1;
        }
        return 0;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        ItemStack tool = entity.func_184607_cu();
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool);
        double c = i != 0 ? (Double)CommonConfigs.SILK_TOUCH_MULTIPLIER.get() : 1.0;
        this.excite(state, world, pos, c * (double)((Integer)CommonConfigs.EXCITE_ON_ATTACK_CHANCE.get()).intValue());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        this.excite(state, world, pos, ((Integer)CommonConfigs.EXCITE_ON_BLOCK_UPDATE_CHANCE.get()).intValue());
    }

    public void excite(BlockState state, World world, BlockPos pos, double chance) {
        if (!world.field_72995_K) {
            if ((double)world.field_73012_v.nextFloat() < chance / 100.0) {
                Direction dir = this.map.higherEntry(world.field_73012_v.nextDouble() * this.total).getValue();
                if (dir == null) {
                    this.teleport(state, (ServerWorld)world, pos);
                } else {
                    this.move(state, world, pos, dir);
                }
            } else if (world.field_73012_v.nextInt(5) == 0) {
                this.lightUp(state, world, pos);
            }
        }
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos end, int eventID, int eventParam) {
        if (eventID == 0) {
            Random random = world.field_73012_v;
            int dx = (eventParam & 0xFF) - 64;
            int dy = (eventParam >> 8 & 0xFF) - 64;
            int dz = (eventParam >> 16 & 0xFF) - 64;
            BlockPos start = new BlockPos(end.func_177958_n() - dx, end.func_177956_o() - dy, end.func_177952_p() - dz);
            for (int j = 0; j < 64; ++j) {
                double d0 = random.nextDouble();
                float f = (random.nextFloat() - 0.5f) * 0.2f;
                float f1 = (random.nextFloat() - 0.5f) * 0.2f;
                float f2 = (random.nextFloat() - 0.5f) * 0.2f;
                double d1 = MathHelper.func_219803_d((double)d0, (double)end.func_177958_n(), (double)start.func_177958_n()) + (random.nextDouble() - 0.5) + 0.5;
                double d2 = MathHelper.func_219803_d((double)d0, (double)end.func_177956_o(), (double)start.func_177956_o()) + random.nextDouble() - 0.5;
                double d3 = MathHelper.func_219803_d((double)d0, (double)end.func_177952_p(), (double)start.func_177952_p()) + (random.nextDouble() - 0.5) + 0.5;
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d1, d2, d3, (double)f, (double)f1, (double)f2);
            }
            return true;
        }
        return super.func_189539_a(state, world, end, eventID, eventParam);
    }

    private void teleport(BlockState state, ServerWorld world, BlockPos pos) {
        int range = 7;
        for (int i = 0; i < 1000; ++i) {
            BlockPos blockpos = pos.func_177982_a(world.field_73012_v.nextInt(7) - world.field_73012_v.nextInt(7), world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3), world.field_73012_v.nextInt(7) - world.field_73012_v.nextInt(7));
            if (!world.func_180495_p(blockpos).func_196958_f()) continue;
            int dx = (byte)(blockpos.func_177958_n() - pos.func_177958_n()) + 64;
            int dy = (byte)(blockpos.func_177956_o() - pos.func_177956_o()) + 64;
            int dz = (byte)(blockpos.func_177952_p() - pos.func_177952_p()) + 64;
            world.func_180501_a(blockpos, state, 2);
            world.func_217377_a(pos, false);
            world.func_175641_c(blockpos, (Block)this, 0, (dz & 0xFF) << 16 | (dy & 0xFF) << 8 | dx & 0xFF);
            return;
        }
    }

    public void move(BlockState state, World world, BlockPos pos, Direction dir) {
        if (FallingBlock.func_185759_i((BlockState)world.func_180495_p(pos.func_177972_a(dir)))) {
            MovingBlockEntity entity = new MovingBlockEntity(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state);
            entity.setGravityDirection(dir);
            world.func_217376_c((Entity)entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (world.field_73012_v.nextInt(5) == 0) {
            this.lightUp(world.func_180495_p(pos), world, pos);
        }
        super.func_176199_a(world, pos, entity);
    }

    private void lightUp(BlockState state, World world, BlockPos pos) {
        RandomiumOreBlock.spawnParticles(world, pos);
        if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)LIT);
    }

    public void func_225542_b_(BlockState state, ServerWorld serverWorld, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            serverWorld.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.FALSE), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            RandomiumOreBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(World world, BlockPos pos) {
        double d0 = 0.5625;
        Random random = world.field_73012_v;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos;
            if (random.nextInt(5) != 0 || world.func_180495_p(blockpos = pos.func_177972_a(direction)).func_200015_d((IBlockReader)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.func_176740_k();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
            world.func_195594_a((IParticleData)ParticleTypes.field_197607_R, (double)pos.func_177958_n() + d1, (double)pos.func_177956_o() + d2, (double)pos.func_177952_p() + d3, 0.0, -0.1, 0.0);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            return this.getBlockRandom(pos).nextInt(10) + 5;
        }
        return 0;
    }
}

