/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.mehvahdjukaar.randomium.Randomium;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class MovingBlockEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private Direction gravityDirection = Direction.DOWN;
    private BlockState blockState = Blocks.field_150354_m.func_176223_P();
    public int time;
    private boolean cancelDrop;
    protected static final DataParameter<BlockPos> DATA_START_POS = EntityDataManager.func_187226_a(FallingBlockEntity.class, (IDataSerializer)DataSerializers.field_187200_j);

    public MovingBlockEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public MovingBlockEntity(World world, double x, double y, double z, BlockState state) {
        this((EntityType<? extends Entity>)((EntityType)Randomium.MOVING_BLOCK_ENTITY.get()), world);
        this.blockState = state;
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setStartPos(this.func_233580_cy_());
    }

    public void setGravityDirection(Direction gravityDirection) {
        this.gravityDirection = gravityDirection;
    }

    public MovingBlockEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends Entity>)((EntityType)Randomium.MOVING_BLOCK_ENTITY.get()), world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(Block.func_196246_j((BlockState)this.blockState));
        buffer.func_179249_a((Enum)this.gravityDirection);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.blockState = Block.func_196257_b((int)additionalData.readInt());
        this.gravityDirection = (Direction)additionalData.func_179257_a(Direction.class);
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.blockState));
        tag.func_74774_a("GravityDirection", (byte)this.gravityDirection.func_176745_a());
        tag.func_74768_a("Time", this.time);
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.blockState = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("BlockState"));
        this.gravityDirection = Direction.func_82600_a((int)tag.func_74771_c("GravityDirection"));
        this.time = tag.func_74762_e("Time");
        if (this.blockState.func_196958_f()) {
            this.blockState = Blocks.field_196611_F.func_176223_P();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_START_POS, (Object)BlockPos.field_177992_a);
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setStartPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(DATA_START_POS, (Object)pos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(DATA_START_POS);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public void func_70071_h_() {
        if (this.blockState.func_196958_f()) {
            this.func_70106_y();
        } else {
            Block block = this.blockState.func_177230_c();
            if (this.time++ == 0) {
                BlockPos blockpos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(blockpos).func_203425_a(block)) {
                    this.field_70170_p.func_217377_a(blockpos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            Vector3i n = this.gravityDirection.func_176730_m();
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)n.func_177958_n() * 0.04, (double)n.func_177956_o() * 0.04, (double)n.func_177952_p() * 0.04));
            }
            this.moveSelf(this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                boolean isVertical;
                BlockPos blockpos1 = this.func_233580_cy_();
                boolean collided = this.field_70124_G || this.field_70123_F;
                boolean bl = isVertical = this.gravityDirection.func_176740_k() == Direction.Axis.Y;
                if (collided || !isVertical && this.field_70146_Z.nextBoolean() && this.func_213303_ch().func_72436_e(Vector3d.func_237492_c_((Vector3i)this.func_233580_cy_())) <= (double)(MathHelper.func_233022_k_((float)((float)this.func_213322_ci().func_216372_d((double)n.func_177958_n(), (double)n.func_177956_o(), (double)n.func_177952_p()).func_72433_c())) / 2.0f)) {
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos1);
                    if (!blockstate.func_203425_a(Blocks.field_196603_bb)) {
                        this.func_70106_y();
                        if (!this.cancelDrop) {
                            boolean flag2 = blockstate.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, blockpos1, this.gravityDirection, ItemStack.field_190927_a, Direction.UP));
                            boolean flag4 = this.blockState.func_196955_c((IWorldReader)this.field_70170_p, blockpos1);
                            if (!(flag2 && flag4 && this.field_70170_p.func_180501_a(blockpos1, this.blockState, 3) || !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g))) {
                                this.func_199703_a((IItemProvider)block);
                            }
                        }
                    }
                } else if (this.time > 100 && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.time > 600) {
                    if (this.gravityDirection == Direction.UP) {
                        this.gravityDirection = Direction.DOWN;
                        this.time = 1;
                    } else {
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                        this.func_70106_y();
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    public void moveSelf(Vector3d movement) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(movement));
            this.func_174829_m();
        } else {
            Vector3d vector3d;
            this.field_70170_p.func_217381_Z().func_76320_a("move");
            if (this.field_213328_B.func_189985_c() > 1.0E-7) {
                movement = movement.func_216369_h(this.field_213328_B);
                this.field_213328_B = Vector3d.field_186680_a;
                this.func_213317_d(Vector3d.field_186680_a);
            }
            if ((vector3d = this.func_213306_e(movement)).func_189985_c() > 1.0E-7) {
                this.func_174826_a(this.func_174813_aQ().func_191194_a(vector3d));
                this.func_174829_m();
            }
            this.field_70170_p.func_217381_Z().func_76319_b();
            this.field_70170_p.func_217381_Z().func_76320_a("rest");
            this.field_70123_F = !MathHelper.func_219806_b((double)movement.field_72450_a, (double)vector3d.field_72450_a) || !MathHelper.func_219806_b((double)movement.field_72449_c, (double)vector3d.field_72449_c);
            this.field_70124_G = movement.field_72448_b != vector3d.field_72448_b;
            this.field_70122_E = this.field_70124_G && movement.field_72448_b < 0.0;
            BlockPos blockpos = this.func_226268_ag_();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            this.func_184231_a(vector3d.field_72448_b, this.field_70122_E, blockstate, blockpos);
            Vector3d vector3d1 = this.func_213322_ci();
            if (movement.field_72450_a != vector3d.field_72450_a) {
                this.func_213293_j(0.0, vector3d1.field_72448_b, vector3d1.field_72449_c);
            }
            if (movement.field_72449_c != vector3d.field_72449_c) {
                this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, 0.0);
            }
            Block block = blockstate.func_177230_c();
            if (movement.field_72448_b != vector3d.field_72448_b) {
                block.func_176216_a((IBlockReader)this.field_70170_p, (Entity)this);
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            float f2 = this.func_225515_ai_();
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)f2, 1.0, (double)f2));
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        int i = MathHelper.func_76123_f((float)(p_225503_1_ - 1.0f));
        if (i > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            boolean flag = this.blockState.func_235714_a_((ITag)BlockTags.field_200572_k);
            DamageSource damagesource = flag ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                float fallDamageAmount = 2.0f;
                int fallDamageMax = 40;
                entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * fallDamageAmount)), fallDamageMax));
            }
            if (flag && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                BlockState blockstate = AnvilBlock.func_196433_f((BlockState)this.blockState);
                if (blockstate == null) {
                    this.cancelDrop = true;
                } else {
                    this.blockState = blockstate;
                }
            }
        }
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_184213_bq() {
        return true;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }
}

