/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium.entity;

import net.mehvahdjukaar.randomium.Randomium;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class MovingBlockEntity
extends FallingBlockEntity
implements IEntityAdditionalSpawnData {
    private Direction gravityDirection = Direction.DOWN;
    private BlockState state;

    public MovingBlockEntity(EntityType<? extends FallingBlockEntity> p_31950_, Level p_31951_) {
        super((EntityType)Randomium.MOVING_BLOCK_ENTITY.get(), p_31951_);
    }

    public MovingBlockEntity(Level level, double x, double y, double z, BlockState state, Direction gravityDirection) {
        super(level, x, y, z, state);
        this.gravityDirection = gravityDirection;
        this.state = state;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)Randomium.MOVING_BLOCK_ENTITY.get();
    }

    public MovingBlockEntity(FMLPlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)Randomium.MOVING_BLOCK_ENTITY.get()), world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState m_31980_() {
        return this.state;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(Block.m_49956_((BlockState)this.m_31980_()));
        buffer.m_130068_((Enum)this.gravityDirection);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.state = Block.m_49803_((int)additionalData.readInt());
        this.gravityDirection = (Direction)additionalData.m_130066_(Direction.class);
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("GravityDirection", (byte)this.gravityDirection.m_122411_());
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.gravityDirection = Direction.m_122376_((int)tag.m_128445_("GravityDirection"));
        this.state = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("BlockState"));
    }

    public void m_8119_() {
        if (this.state.m_60795_()) {
            this.m_146870_();
        } else {
            Block block = this.state.m_60734_();
            if (this.f_31942_++ == 0) {
                BlockPos blockpos = this.m_142538_();
                if (this.f_19853_.m_8055_(blockpos).m_60713_(block)) {
                    this.f_19853_.m_7471_(blockpos, false);
                } else if (!this.f_19853_.f_46443_) {
                    this.m_146870_();
                    return;
                }
            }
            Vec3i n = this.gravityDirection.m_122436_();
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_((double)n.m_123341_() * 0.04, (double)n.m_123342_() * 0.04, (double)n.m_123343_() * 0.04));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.f_19853_.f_46443_) {
                boolean isVertical;
                BlockPos blockpos1 = this.m_142538_();
                boolean collided = this.f_19863_ || this.f_19862_;
                boolean bl = isVertical = this.gravityDirection.m_122434_() == Direction.Axis.Y;
                if (collided || !isVertical && this.f_19796_.nextBoolean() && this.m_20182_().m_82557_(Vec3.m_82539_((Vec3i)this.m_142538_())) <= (double)(Mth.m_14207_((float)((float)this.m_20184_().m_82542_((double)n.m_123341_(), (double)n.m_123342_(), (double)n.m_123343_()).m_82553_())) / 2.0f)) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos1);
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        this.m_146870_();
                        boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockpos1, this.gravityDirection, ItemStack.f_41583_, Direction.UP));
                        boolean flag4 = this.state.m_60710_((LevelReader)this.f_19853_, blockpos1);
                        if (!(flag2 && flag4 && this.f_19853_.m_7731_(blockpos1, this.state, 3) || !this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_))) {
                            this.m_19998_((ItemLike)block);
                        }
                    }
                } else if (this.f_31942_ > 100 && (blockpos1.m_123342_() < 1 || blockpos1.m_123342_() > 256) || this.f_31942_ > 600) {
                    if (this.gravityDirection == Direction.UP) {
                        this.gravityDirection = Direction.DOWN;
                        this.f_31942_ = 1;
                    } else {
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_146870_();
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }
}

