/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.mehvahdjukaar.randomium.block.RandomiumOreBlock;
import net.mehvahdjukaar.randomium.client.MovingBlockEntityRenderer;
import net.mehvahdjukaar.randomium.configs.CommonConfigs;
import net.mehvahdjukaar.randomium.entity.MovingBlockEntity;
import net.mehvahdjukaar.randomium.items.AnyItem;
import net.mehvahdjukaar.randomium.items.RandomiumItem;
import net.mehvahdjukaar.randomium.recipes.RandomiumDuplicateRecipe;
import net.mehvahdjukaar.randomium.world.FeatureRegistry;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="randomium")
public class Randomium {
    public static final String MOD_ID = "randomium";
    private static final Logger LOGGER = LogManager.getLogger();
    private static Random RAND = new Random();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"randomium");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"randomium");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"randomium");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"randomium");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"randomium");
    public static final RegistryObject<Block> RANDOMIUM_ORE = BLOCKS.register("randomium_ore", () -> new RandomiumOreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(4.0f, 3.0f)));
    public static final RegistryObject<Block> RANDOMIUM_ORE_DEEP = BLOCKS.register("randomium_ore_deepslate", () -> new RandomiumOreBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_).m_60999_().m_60913_(5.25f, 3.0f)));
    public static final RegistryObject<Item> RANDOMIUM_ORE_DEEP_ITEM = ITEMS.register("randomium_ore_deepslate", () -> new BlockItem((Block)RANDOMIUM_ORE_DEEP.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
    public static final RegistryObject<Item> RANDOMIUM_ORE_ITEM = ITEMS.register("randomium_ore", () -> new BlockItem((Block)RANDOMIUM_ORE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
    public static final RegistryObject<Block> RANDOMIUM_ORE_END = BLOCKS.register("randomium_ore_end", () -> new RandomiumOreBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_).m_60999_().m_60913_(4.0f, 3.0f)));
    public static final RegistryObject<Item> RANDOMIUM_END_ORE_ITEM = ITEMS.register("randomium_ore_end", () -> new BlockItem((Block)RANDOMIUM_ORE_END.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
    public static final RegistryObject<Item> RANDOMIUM_ITEM = ITEMS.register("randomium", () -> new RandomiumItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.EPIC)));
    public static final RegistryObject<Item> DUPLICATE_ITEM = ITEMS.register("any_item", () -> new AnyItem(new Item.Properties().m_41491_(null)));
    public static final RegistryObject<EntityType<MovingBlockEntity>> MOVING_BLOCK_ENTITY = ENTITIES.register("moving_block", () -> EntityType.Builder.m_20704_(MovingBlockEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.98f).m_20702_(10).m_20717_(20).setCustomClientFactory(MovingBlockEntity::new).m_20712_("moving_block"));
    public static final RegistryObject<RecipeSerializer<?>> RANDOMIUM_CLONE_RECIPE = RECIPES.register("randomium_clone", () -> new SimpleRecipeSerializer(RandomiumDuplicateRecipe::new));
    private static final List<List<ItemStack>> LOOT = new ArrayList<List<ItemStack>>();
    private static final List<ItemStack> SHUFFLED_ANY_ITEM = new ArrayList<ItemStack>();
    private static final List<SoundType> SOUNDS = new ArrayList<SoundType>();
    public static Tags.IOptionalNamedTag<Item> BLACKLIST = ItemTags.createOptional((ResourceLocation)Randomium.res("blacklist"));
    public static Tags.IOptionalNamedTag<Item> WHITELIST = ItemTags.createOptional((ResourceLocation)Randomium.res("whitelist"));
    private static final Predicate<Item> VALID_DROP = i -> {
        if (i == Items.f_41852_) {
            return false;
        }
        if (BLACKLIST.m_8110_(i)) {
            return false;
        }
        if (i instanceof SpawnEggItem) {
            return false;
        }
        ResourceLocation reg = i.getRegistryName();
        if (((List)CommonConfigs.MOD_BLACKLIST.get()).contains(reg.m_135827_())) {
            return false;
        }
        String name = reg.m_135815_();
        return !name.contains("creative") && !name.contains("debug") && !name.contains("developer") && !name.contains("dev_") && !name.contains("_dev");
    };

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public Randomium() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        ENTITIES.register(bus);
        RECIPES.register(bus);
        FEATURES.register(bus);
        CommonConfigs.registerSpec();
        bus.addListener(EventPriority.LOWEST, this::setup);
        bus.addListener(this::entityRenderers);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ItemStack getRandomItem(Random random) {
        List<ItemStack> list = LOOT.get(random.nextInt(LOOT.size()));
        return list.get(random.nextInt(list.size())).m_41777_();
    }

    public static ItemStack getAnyItem() {
        int size = SHUFFLED_ANY_ITEM.size();
        int time = (int)(Util.m_137550_() / 500L);
        return SHUFFLED_ANY_ITEM.get(time % size);
    }

    public static SoundType getRandomSound(Random random) {
        return SOUNDS.get(random.nextInt(SOUNDS.size()));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        FeatureRegistry.addFeatureToBiomes(event);
    }

    @SubscribeEvent
    public void onTagLoad(TagsUpdatedEvent event) {
        if (LOOT.isEmpty()) {
            if (CommonConfigs.LOOT_MODE.get() == ListMode.BLACKLIST) {
                ForgeRegistries.ITEMS.getValues().stream().filter(VALID_DROP).forEach(i -> {
                    NonNullList temp = NonNullList.m_122779_();
                    try {
                        Arrays.stream(CreativeModeTab.f_40748_).forEach(t -> i.m_6787_(t, temp));
                        if (!temp.isEmpty()) {
                            LOOT.add((List<ItemStack>)temp);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                LOOT.add(Collections.singletonList(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43595_)));
            } else {
                WHITELIST.m_6497_().stream().map(Item::m_7968_).forEach(i -> LOOT.add(Collections.singletonList(i)));
            }
        }
        SHUFFLED_ANY_ITEM.clear();
        SHUFFLED_ANY_ITEM.addAll(LOOT.stream().map(l -> (ItemStack)l.get(0)).collect(Collectors.toList()));
        Collections.shuffle(SHUFFLED_ANY_ITEM);
    }

    private void setup(FMLCommonSetupEvent event) {
        FeatureRegistry.init();
        ForgeRegistries.BLOCKS.getValues().stream().map(b -> b.m_49962_(b.m_49966_())).filter(s -> !SOUNDS.contains(s)).forEach(SOUNDS::add);
    }

    public void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)MOVING_BLOCK_ENTITY.get(), MovingBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
    }

    public static enum ListMode {
        BLACKLIST,
        WHITELIST;

    }
}

