/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.lizardofoz.searchlight.PacketStuff;
import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightBlock;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.block.SearchlightBlockRenderer;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlock;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlockEntity;
import me.lizardofoz.searchlight.block.WallLightBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="searchlight")
public final class SearchlightModForge
extends SearchlightMod {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"searchlight");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"searchlight");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"searchlight");

    public SearchlightModForge() {
        PacketStuff.initialize();
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        creativeItemGroup = new ItemGroup("searchlight"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)SearchlightMod.searchlightBlock);
            }
        };
        blockEntitySynchronizer = PacketStuff::sendUpdateRequestToClient;
        blockEntityConstructor = SearchlightBlockEntity::new;
        this.registerSearchlightBlock();
        this.registerSearchlightLightSourceBlock();
        this.registerWallLightBlocks();
    }

    private void registerSearchlightBlock() {
        searchlightBlock = new SearchlightBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_235861_h_().func_200943_b(5.0f).func_226896_b_());
        searchlightItem = new BlockItem(searchlightBlock, new Item.Properties().func_200916_a(creativeItemGroup));
        searchlightBlockEntityType = TileEntityType.Builder.func_223042_a((Supplier)blockEntityConstructor, (Block[])new Block[]{searchlightBlock}).func_206865_a(null);
        BLOCKS.register("searchlight", () -> searchlightBlock);
        ITEMS.register("searchlight", () -> searchlightItem);
        TILE_ENTITIES.register("searchlight_entity", () -> searchlightBlockEntityType);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientRegistry.bindTileEntityRenderer((TileEntityType)searchlightBlockEntityType, SearchlightBlockRenderer::new);
        }
    }

    private void registerSearchlightLightSourceBlock() {
        lightSourceBlock = new SearchlightLightSourceBlock(AbstractBlock.Properties.func_200945_a((Material)new Material.Builder(MaterialColor.field_151660_b).func_200509_f().func_200502_b().func_200506_i()).func_200947_a(SoundType.field_185848_a).func_200943_b(3600000.8f).func_222380_e().func_226896_b_().func_235838_a_(state -> 15));
        lightSourceBlockEntityType = TileEntityType.Builder.func_223042_a(SearchlightLightSourceBlockEntity::new, (Block[])new Block[]{lightSourceBlock}).func_206865_a(null);
        BLOCKS.register("searchlight_lightsource", () -> lightSourceBlock);
        TILE_ENTITIES.register("searchlight_lightsource_entity", () -> lightSourceBlockEntityType);
    }

    private void registerWallLightBlocks() {
        HashMap<Block, Item> wallLights = new HashMap<Block, Item>();
        this.registerWallLight("iron", wallLights);
        this.registerWallLight("copper", wallLights);
        this.registerWallLight("prismarine", wallLights);
        for (DyeColor color : DyeColor.values()) {
            this.registerWallLight(color.func_176762_d(), wallLights);
        }
        wallLightBlocks = ImmutableMap.copyOf(wallLights);
    }

    private void registerWallLight(String postfix, Map<Block, Item> wallLightMap) {
        WallLightBlock block = new WallLightBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.5f).func_235838_a_(state -> 14).func_200947_a(SoundType.field_185851_d).func_226896_b_().func_200942_a());
        BlockItem item = new BlockItem((Block)block, new Item.Properties().func_200916_a(creativeItemGroup));
        BLOCKS.register("wall_light_" + postfix, () -> SearchlightModForge.lambda$registerWallLight$7((Block)block));
        ITEMS.register("wall_light_" + postfix, () -> SearchlightModForge.lambda$registerWallLight$8((Item)item));
        wallLightMap.put((Block)block, (Item)item);
    }

    private static /* synthetic */ Item lambda$registerWallLight$8(Item item) {
        return item;
    }

    private static /* synthetic */ Block lambda$registerWallLight$7(Block block) {
        return block;
    }
}

