/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlock;
import me.lizardofoz.searchlight.util.MutableVector3d;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.lighting.LightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchlightBlockEntity
extends TileEntity {
    @Nullable
    private BlockPos lightSourcePos;

    public SearchlightBlockEntity() {
        super(SearchlightMod.getSearchlightBlockEntityType());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.lightSourcePos != null) {
            tag.func_74768_a("light_source_x", this.lightSourcePos.func_177958_n());
            tag.func_74768_a("light_source_y", this.lightSourcePos.func_177956_o());
            tag.func_74768_a("light_source_z", this.lightSourcePos.func_177952_p());
        }
        return tag;
    }

    public CompoundNBT toClientTag(@NotNull CompoundNBT tag) {
        return this.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.fromClientTag(tag);
    }

    public void fromClientTag(@NotNull CompoundNBT tag) {
        this.lightSourcePos = tag.func_74764_b("light_source_x") && tag.func_74764_b("light_source_y") && tag.func_74764_b("light_source_z") ? new BlockPos(tag.func_74762_e("light_source_x"), tag.func_74762_e("light_source_y"), tag.func_74762_e("light_source_z")) : null;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return SearchlightUtil.displayBeams() ? 256.0 : super.func_145833_n();
    }

    @NotNull
    public Vector3d getBeamDirection() {
        if (this.lightSourcePos == null) {
            return SearchlightUtil.directionToBeamVector(SearchlightUtil.getDirection(this.func_195044_w()));
        }
        BlockPos delta = this.lightSourcePos.func_177973_b((Vector3i)this.func_174877_v());
        return new Vector3d((double)delta.func_177958_n(), (double)delta.func_177956_o(), (double)delta.func_177952_p()).func_72432_b();
    }

    public boolean deleteLightSource() {
        BlockPos oldLightSourcePos = this.lightSourcePos;
        this.setLightSourcePos(null);
        if (oldLightSourcePos != null && SearchlightUtil.getBlockStateForceLoad(this.field_145850_b, oldLightSourcePos).func_177230_c() instanceof SearchlightLightSourceBlock) {
            return SearchlightUtil.setBlockStateForceLoad(this.field_145850_b, oldLightSourcePos, Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    public boolean raycastAndPlaceLightSource(@NotNull Vector3d beamDirection) {
        BlockPos newLightPos = this.calculateLightSourcePosition(beamDirection = beamDirection.func_72432_b());
        return newLightPos != null && this.placeLightSource(newLightPos);
    }

    public boolean placeLightSource(@Nullable BlockPos newLightPos) {
        this.deleteLightSource();
        if (newLightPos == null) {
            this.setLightSourcePos(null);
            return false;
        }
        BlockState oldBlockState = SearchlightUtil.getBlockStateForceLoad(this.field_145850_b, newLightPos);
        if (!SearchlightUtil.setBlockStateForceLoad(this.field_145850_b, newLightPos, SearchlightMod.getLightSourceBlock().func_176223_P())) {
            return false;
        }
        if (!SearchlightUtil.castBlockEntity(this.field_145850_b.func_175625_s(newLightPos), newLightPos, lightBlockEntity -> {
            lightBlockEntity.searchlightBlockPos = this.func_174877_v();
            this.setLightSourcePos(newLightPos);
        })) {
            SearchlightUtil.setBlockStateForceLoad(this.field_145850_b, newLightPos, oldBlockState);
            this.setLightSourcePos(null);
            return false;
        }
        return true;
    }

    @Nullable
    public BlockPos calculateLightSourcePosition(@NotNull Vector3d beamDirection) {
        beamDirection = beamDirection.func_72432_b();
        AbstractChunkProvider chunkManager = this.field_145850_b.func_72863_F();
        MutableVector3d currentBlockPosD = new MutableVector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        BlockPos.Mutable currentBlockPos = new BlockPos.Mutable(currentBlockPosD.x, currentBlockPosD.y, currentBlockPosD.z);
        BlockPos.Mutable prevBlockPos = new BlockPos.Mutable(0, 0, 0);
        BlockPos.Mutable currentChunkPos = new BlockPos.Mutable(0, 0, 0);
        BlockPos.Mutable prevChunkPos = new BlockPos.Mutable(0, 0, 0);
        BlockPos lastValidBlockPos = null;
        while (true) {
            prevBlockPos.func_189533_g((Vector3i)currentBlockPos);
            currentBlockPosD.add(beamDirection);
            currentBlockPos.func_189532_c(currentBlockPosD.x, currentBlockPosD.y, currentBlockPosD.z);
            if (prevBlockPos.equals((Object)currentBlockPos)) continue;
            if (!World.func_175701_a((BlockPos)currentBlockPos)) {
                return null;
            }
            prevChunkPos.func_181079_c(prevBlockPos.func_177958_n() >> 4, 0, prevBlockPos.func_177952_p() >> 4);
            currentChunkPos.func_181079_c(currentBlockPos.func_177958_n() >> 4, 0, currentBlockPos.func_177952_p() >> 4);
            if (!prevChunkPos.equals((Object)currentChunkPos) && !chunkManager.func_73149_a(currentChunkPos.func_177958_n(), currentChunkPos.func_177952_p())) {
                return null;
            }
            BlockState currentBlockState = SearchlightUtil.getBlockStateForceLoad(this.field_145850_b, (BlockPos)currentBlockPos);
            BlockState prevBlockState = SearchlightUtil.getBlockStateForceLoad(this.field_145850_b, (BlockPos)prevBlockPos);
            if (LightEngine.func_215613_a((IBlockReader)this.field_145850_b, (BlockState)prevBlockState, (BlockPos)prevBlockPos, (BlockState)currentBlockState, (BlockPos)currentBlockPos, (Direction)Direction.func_210769_a((double)beamDirection.field_72450_a, (double)beamDirection.field_72448_b, (double)beamDirection.field_72449_c), (int)currentBlockState.func_200016_a((IBlockReader)this.field_145850_b, (BlockPos)currentBlockPos)) >= this.field_145850_b.func_201572_C() || !this.field_145850_b.func_204610_c((BlockPos)currentBlockPos).func_206888_e()) {
                return SearchlightUtil.moveAwayFromSurfaces(this.field_145850_b, lastValidBlockPos);
            }
            if (!currentBlockState.func_196958_f() && !currentBlockPos.equals((Object)this.lightSourcePos)) continue;
            lastValidBlockPos = currentBlockPos.func_185334_h();
        }
    }

    protected void setLightSourcePos(@Nullable BlockPos lightSourcePos) {
        this.lightSourcePos = lightSourcePos;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            SearchlightMod.getBlockEntitySynchronizer().accept(this);
        }
    }

    @Nullable
    public BlockPos getLightSourcePos() {
        return this.lightSourcePos;
    }
}

