/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.util.MutableVector3d;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchlightLightSourceBlockEntity
extends TileEntity {
    @Nullable
    public BlockPos searchlightBlockPos;

    public SearchlightLightSourceBlockEntity() {
        super(SearchlightMod.getLightSourceBlockEntityType());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.searchlightBlockPos != null) {
            tag.func_74768_a("searchlight_x", this.searchlightBlockPos.func_177958_n());
            tag.func_74768_a("searchlight_y", this.searchlightBlockPos.func_177956_o());
            tag.func_74768_a("searchlight_z", this.searchlightBlockPos.func_177952_p());
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.searchlightBlockPos = tag.func_74764_b("searchlight_x") && tag.func_74764_b("searchlight_y") && tag.func_74764_b("searchlight_z") ? new BlockPos(tag.func_74762_e("searchlight_x"), tag.func_74762_e("searchlight_y"), tag.func_74762_e("searchlight_z")) : null;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void moveLightSource() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.searchlightBlockPos == null) {
            return;
        }
        SearchlightUtil.castBlockEntity(this.field_145850_b.func_175625_s(this.searchlightBlockPos), this.searchlightBlockPos, searchlightBlockEntity -> {
            if (this.func_174877_v().equals((Object)searchlightBlockEntity.getLightSourcePos())) {
                searchlightBlockEntity.placeLightSource(this.calculateLightSourcePosition(searchlightBlockEntity.getBeamDirection().func_186678_a(-1.0)));
            }
        });
    }

    @Nullable
    public BlockPos calculateLightSourcePosition(@NotNull Vector3d direction) {
        direction = direction.func_72432_b();
        AbstractChunkProvider chunkManager = this.field_145850_b.func_72863_F();
        MutableVector3d currentBlockPosD = new MutableVector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        BlockPos.Mutable currentBlockPos = new BlockPos.Mutable(currentBlockPosD.x, currentBlockPosD.y, currentBlockPosD.z);
        BlockPos.Mutable prevBlockPos = new BlockPos.Mutable(0, 0, 0);
        BlockPos.Mutable currentChunkPos = new BlockPos.Mutable(0, 0, 0);
        BlockPos.Mutable prevChunkPos = new BlockPos.Mutable(0, 0, 0);
        while (true) {
            prevBlockPos.func_189533_g((Vector3i)currentBlockPos);
            currentBlockPosD.add(direction);
            currentBlockPos.func_189532_c(currentBlockPosD.x, currentBlockPosD.y, currentBlockPosD.z);
            if (prevBlockPos.equals((Object)currentBlockPos)) continue;
            if (!World.func_175701_a((BlockPos)currentBlockPos)) {
                return null;
            }
            prevChunkPos.func_181079_c(prevBlockPos.func_177958_n() >> 4, 0, prevBlockPos.func_177952_p() >> 4);
            currentChunkPos.func_181079_c(currentBlockPos.func_177958_n() >> 4, 0, currentBlockPos.func_177952_p() >> 4);
            if (!prevChunkPos.equals((Object)currentChunkPos) && !chunkManager.func_73149_a(currentChunkPos.func_177958_n(), currentChunkPos.func_177952_p())) {
                return null;
            }
            if (currentBlockPos.equals((Object)this.searchlightBlockPos)) {
                return null;
            }
            if (SearchlightUtil.getBlockStateIfLoaded(this.field_145850_b, (BlockPos)currentBlockPos).func_196958_f()) break;
        }
        return SearchlightUtil.moveAwayFromSurfaces(this.field_145850_b, (BlockPos)currentBlockPos);
    }
}

