/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightBlock;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.block.SearchlightBlockRenderer;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlock;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlockEntity;
import me.lizardofoz.searchlight.block.WallLightBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="searchlight")
public final class SearchlightModForge
extends SearchlightMod {
    private HashMap<String, Object> wallLightTypes = new HashMap();

    public SearchlightModForge() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        creativeItemGroup = new CreativeModeTab("searchlight"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)SearchlightMod.searchlightBlock);
            }
        };
        this.wallLightTypes.put("iron", new Object());
        this.wallLightTypes.put("copper", new Object());
        this.wallLightTypes.put("prismarine", new Object());
        for (DyeColor color : DyeColor.values()) {
            this.wallLightTypes.put(color.m_41065_(), new Object());
        }
    }

    @SubscribeEvent
    public void registerSearchlightBlock(RegistryEvent.Register<Block> event) {
        searchlightBlock = (Block)new SearchlightBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76398_).m_60918_(SoundType.f_56743_).m_60978_(4.0f).m_60999_().m_60955_()).setRegistryName("searchlight");
        event.getRegistry().register((IForgeRegistryEntry)searchlightBlock);
        lightSourceBlock = (Block)new SearchlightLightSourceBlock(BlockBehaviour.Properties.m_60939_((Material)new Material.Builder(MaterialColor.f_76398_).m_76356_().m_76353_().m_76359_()).m_60918_(SoundType.f_56736_).m_60978_(3600000.8f).m_60993_().m_60955_().m_60953_(state -> 15)).setRegistryName("searchlight_lightsource");
        event.getRegistry().register((IForgeRegistryEntry)lightSourceBlock);
    }

    @SubscribeEvent
    public void registerSearchlightBlockItem(RegistryEvent.Register<Item> event) {
        searchlightItem = new BlockItem(searchlightBlock, new Item.Properties().m_41491_(creativeItemGroup));
        searchlightItem.setRegistryName("searchlight");
        event.getRegistry().register((IForgeRegistryEntry)searchlightItem);
    }

    @SubscribeEvent
    public void registerLightBlockEntity(RegistryEvent.Register<BlockEntityType<?>> event) {
        searchlightBlockEntityType = BlockEntityType.Builder.m_155273_(SearchlightBlockEntity::new, (Block[])new Block[]{searchlightBlock}).m_58966_(null);
        searchlightBlockEntityType.setRegistryName("searchlight_entity");
        event.getRegistry().register((IForgeRegistryEntry)searchlightBlockEntityType);
        lightSourceBlockEntityType = BlockEntityType.Builder.m_155273_(SearchlightLightSourceBlockEntity::new, (Block[])new Block[]{lightSourceBlock}).m_58966_(null);
        lightSourceBlockEntityType.setRegistryName("searchlight_lightsource_entity");
        event.getRegistry().register((IForgeRegistryEntry)lightSourceBlockEntityType);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(searchlightBlockEntityType, SearchlightBlockRenderer::new);
    }

    @SubscribeEvent
    public void registerWallLightBlocks(RegistryEvent.Register<Block> event) {
        for (String postfix : new ArrayList<String>(this.wallLightTypes.keySet())) {
            WallLightBlock block = new WallLightBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.5f).m_60953_(state -> 14).m_60918_(SoundType.f_56742_).m_60955_().m_60910_());
            block.setRegistryName("wall_light_" + postfix);
            event.getRegistry().register((IForgeRegistryEntry)block);
            this.wallLightTypes.put(postfix, (Object)block);
        }
    }

    @SubscribeEvent
    public void registerWallLightBlockItems(RegistryEvent.Register<Item> event) {
        for (Map.Entry<String, Object> entry : this.wallLightTypes.entrySet()) {
            Block block = (Block)entry.getValue();
            Item item = (Item)new BlockItem(block, new Item.Properties().m_41491_(creativeItemGroup)).setRegistryName("wall_light_" + entry.getKey());
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }
}

