/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.message.Message;
import fuzs.puzzleslib.proxy.IProxy;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class NetworkHandler {
    private final BiMap<Class<? extends Message>, class_2960> messageRegistry = HashBiMap.create();
    private final String modId;
    private final AtomicInteger discriminator;

    private NetworkHandler(String modId) {
        this.modId = modId;
        this.discriminator = new AtomicInteger();
    }

    public <T extends Message> void register(Class<T> clazz, Supplier<T> supplier, MessageDirection direction) {
        class_2960 channelName = this.nextIdentifier();
        this.messageRegistry.put(clazz, (Object)channelName);
        Function<class_2540, Message> decode = buf -> PuzzlesUtil.make((Message)supplier.get(), message -> message.read((class_2540)buf));
        switch (direction) {
            case TO_CLIENT: {
                IProxy.INSTANCE.registerClientReceiver(channelName, decode);
                break;
            }
            case TO_SERVER: {
                IProxy.INSTANCE.registerServerReceiver(channelName, decode);
            }
        }
    }

    private class_2960 nextIdentifier() {
        return new class_2960(this.modId, "play/" + this.discriminator.getAndIncrement());
    }

    public void sendToServer(Message message) {
        Objects.requireNonNull(class_310.method_1551().method_1562(), "Cannot send packets when not in game!");
        class_310.method_1551().method_1562().method_2883(this.toServerboundPacket(message));
    }

    public void sendTo(Message message, class_3222 player) {
        player.field_13987.method_14364(this.toClientboundPacket(message));
    }

    public void sendToAll(Message message) {
        IProxy.INSTANCE.getGameServer().method_3760().method_14581(this.toClientboundPacket(message));
    }

    public void sendToAllExcept(Message message, class_3222 exclude) {
        class_2596<?> packet = this.toClientboundPacket(message);
        for (class_3222 player : IProxy.INSTANCE.getGameServer().method_3760().method_14571()) {
            if (player == exclude) continue;
            player.field_13987.method_14364(packet);
        }
    }

    public void sendToAllNear(Message message, class_2338 pos, class_1937 level) {
        this.sendToAllNearExcept(message, null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, level);
    }

    public void sendToAllNearExcept(Message message, @Nullable class_3222 exclude, double posX, double posY, double posZ, double distance, class_1937 level) {
        IProxy.INSTANCE.getGameServer().method_3760().method_14605((class_1657)exclude, posX, posY, posZ, distance, level.method_27983(), this.toClientboundPacket(message));
    }

    public void sendToDimension(Message message, class_1937 level) {
        this.sendToDimension(message, (class_5321<class_1937>)level.method_27983());
    }

    public void sendToDimension(Message message, class_5321<class_1937> dimension) {
        IProxy.INSTANCE.getGameServer().method_3760().method_14589(this.toClientboundPacket(message), dimension);
    }

    private class_2596<?> toServerboundPacket(Message message) {
        class_2960 identifier = (class_2960)this.messageRegistry.get(message.getClass());
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return ClientPlayNetworking.createC2SPacket((class_2960)identifier, (class_2540)byteBuf);
    }

    private class_2596<?> toClientboundPacket(Message message) {
        class_2960 identifier = (class_2960)this.messageRegistry.get(message.getClass());
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return ServerPlayNetworking.createS2CPacket((class_2960)identifier, (class_2540)byteBuf);
    }

    public static NetworkHandler of(String modId) {
        return new NetworkHandler(modId);
    }
}

