/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.registry;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.PuzzlesLib;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import org.apache.commons.lang3.StringUtils;

public class RegistryManager {
    private static final Map<String, RegistryManager> MOD_TO_REGISTRY = Maps.newConcurrentMap();
    private final String namespace;

    private RegistryManager(String namespace) {
        this.namespace = namespace;
    }

    public <T> T register(class_2378<? super T> registry, String path, Supplier<T> entry) {
        T e = entry.get();
        Objects.requireNonNull(e, "Can't register null object");
        return (T)class_2378.method_10230(registry, (class_2960)this.locate(path), e);
    }

    public class_2248 registerBlock(String path, Supplier<class_2248> entry) {
        return this.register((class_2378)class_2378.field_11146, path, entry);
    }

    public class_2248 registerBlockWithItem(String path, Supplier<class_2248> entry, class_1761 creativeTab) {
        return this.registerBlockWithItem(path, entry, new class_1792.class_1793().method_7892(creativeTab));
    }

    public class_2248 registerBlockWithItem(String path, Supplier<class_2248> entry, class_1792.class_1793 properties) {
        class_2248 block = this.registerBlock(path, entry);
        this.registerBlockItem(path, properties);
        return block;
    }

    public class_3611 registerFluid(String path, Supplier<class_3611> entry) {
        return this.register((class_2378)class_2378.field_11154, path, entry);
    }

    public class_1792 registerItem(String path, Function<class_1792.class_1793, class_1792> entry, class_1761 creativeTab) {
        return this.registerItem(path, () -> (class_1792)entry.apply(new class_1792.class_1793().method_7892(creativeTab)));
    }

    public class_1792 registerItem(String path, Supplier<class_1792> entry) {
        return this.register((class_2378)class_2378.field_11142, path, entry);
    }

    public class_1792 registerBlockItem(String path, class_1761 creativeTab) {
        return this.registerBlockItem(path, new class_1792.class_1793().method_7892(creativeTab));
    }

    public class_1792 registerBlockItem(String path, class_1792.class_1793 properties) {
        return this.registerItem(path, () -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(this.locate(path));
            Objects.requireNonNull(block, "Can't register item for null block");
            return new class_1747(block, properties);
        });
    }

    public class_1291 registerMobEffect(String path, Supplier<class_1291> entry) {
        return this.register(class_2378.field_11159, path, entry);
    }

    public class_3414 registerRawSoundEvent(String path) {
        return this.registerSoundEvent(path, () -> new class_3414(this.locate(path)));
    }

    public class_3414 registerSoundEvent(String path, Supplier<class_3414> entry) {
        return this.register(class_2378.field_11156, path, entry);
    }

    public class_1842 registerPotion(String path, Supplier<class_1842> entry) {
        return this.register((class_2378)class_2378.field_11143, path, entry);
    }

    public class_1887 registerEnchantment(String path, Supplier<class_1887> entry) {
        return this.register(class_2378.field_11160, path, entry);
    }

    public <T extends class_1297> class_1299<T> registerRawEntityType(String path, Supplier<class_1299.class_1300<T>> entry) {
        return this.registerEntityType(path, () -> ((class_1299.class_1300)entry.get()).method_5905(path));
    }

    public <T extends class_1297> class_1299<T> registerEntityType(String path, Supplier<class_1299<T>> entry) {
        return this.register((class_2378<? super T>)class_2378.field_11145, path, entry);
    }

    public <T extends class_2586> class_2591<T> registerRawBlockEntityType(String path, Supplier<FabricBlockEntityTypeBuilder<T>> entry) {
        return this.registerBlockEntityType(path, () -> ((FabricBlockEntityTypeBuilder)entry.get()).build());
    }

    public <T extends class_2586> class_2591<T> registerBlockEntityType(String path, Supplier<class_2591<T>> entry) {
        return this.register(class_2378.field_11137, path, entry);
    }

    public <T extends class_1703> class_3917<T> registerRawMenuType(String path, Supplier<ScreenHandlerRegistry.SimpleClientHandlerFactory<T>> entry) {
        ScreenHandlerRegistry.SimpleClientHandlerFactory<T> e = entry.get();
        Objects.requireNonNull(e, "Can't register null object");
        return ScreenHandlerRegistry.registerSimple((class_2960)this.locate(path), e);
    }

    public <T extends class_1703> class_3917<T> registerMenuType(String path, Supplier<class_3917<T>> entry) {
        return this.register(class_2378.field_17429, path, entry);
    }

    private class_2960 locate(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new class_2960(this.namespace, path);
    }

    public static RegistryManager of(String namespace) {
        return MOD_TO_REGISTRY.computeIfAbsent(namespace, namespace1 -> {
            PuzzlesLib.LOGGER.info("Creating registry manager for mod id {}", (Object)namespace);
            return new RegistryManager((String)namespace1);
        });
    }
}

