/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.ConfigHolderImpl;
import fuzs.universalbonemeal.api.event.entity.player.BonemealCallback;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalBoneMeal
implements ModInitializer {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final ConfigHolder<AbstractConfig, ServerConfig> CONFIG = ConfigHolder.server(() -> new ServerConfig());

    public static void onConstructMod() {
        ((ConfigHolderImpl)CONFIG).addConfigs(MOD_ID);
        UniversalBoneMeal.registerHandlers();
    }

    private static void registerHandlers() {
        BonemealHandler bonemealHandler = new BonemealHandler();
        BonemealCallback.EVENT.register(bonemealHandler::onBonemeal);
        CONFIG.addServerCallback(bonemealHandler::invalidate);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            bonemealHandler.invalidate();
            CoralBehavior.invalidate();
        });
    }

    public static void onCommonSetup() {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        BonemealHandler.registerBehavior(class_2246.field_10029, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowCactus);
        BonemealHandler.registerBehavior(class_2246.field_10424, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowSugarCane);
        BonemealHandler.registerBehavior(class_2246.field_10597, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowVines);
        BonemealHandler.registerBehavior(class_2246.field_9974, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowNetherWart);
        BonemealHandler.registerBehavior(Sets.newHashSet((Object[])new class_2248[]{class_2246.field_10168, class_2246.field_9984}), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowFruitStems);
        BonemealHandler.registerBehavior(class_2246.field_10588, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowLilyPad);
        BonemealHandler.registerBehavior(class_2246.field_10428, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowDeadBush);
        BonemealHandler.registerBehavior((class_6862<class_2248>)class_3481.field_15480, () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowSmallFlowers);
        BonemealHandler.registerBehavior((class_6862<class_2248>)class_3481.field_15483, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowCorals);
        BonemealHandler.registerBehavior(class_2246.field_10528, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowChorus);
        BonemealHandler.registerBehavior(class_2246.field_10021, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowChorus);
        BonemealHandler.registerBehavior(class_2246.field_10402, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowMycelium);
        BonemealHandler.registerBehavior(Sets.newHashSet((Object[])new class_2248[]{class_2246.field_10566, class_2246.field_10253, class_2246.field_10194}), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowDirt);
    }

    public void onInitialize() {
        UniversalBoneMeal.onConstructMod();
        UniversalBoneMeal.onCommonSetup();
    }
}

