/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.ConfigHolderImpl;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="universalbonemeal")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UniversalBoneMeal {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final ConfigHolder<AbstractConfig, ServerConfig> CONFIG = ConfigHolder.server(() -> new ServerConfig());

    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ((ConfigHolderImpl)CONFIG).addConfigs(MOD_ID);
        UniversalBoneMeal.registerHandlers();
    }

    private static void registerHandlers() {
        BonemealHandler bonemealHandler = new BonemealHandler();
        MinecraftForge.EVENT_BUS.addListener(bonemealHandler::onBonemeal);
        CONFIG.addServerCallback(bonemealHandler::invalidate);
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.addListener((p_10638_, p_10639_, p_10640_, p_10641_, p_10642_, p_10643_) -> p_10638_.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
            bonemealHandler.invalidate();
            CoralBehavior.invalidate();
        })));
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent evt) {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        BonemealHandler.registerBehavior(Blocks.f_50128_, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowCactus);
        BonemealHandler.registerBehavior(Blocks.f_50130_, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowSugarCane);
        BonemealHandler.registerBehavior(Blocks.f_50191_, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowVines);
        BonemealHandler.registerBehavior(Blocks.f_50200_, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowNetherWart);
        BonemealHandler.registerBehavior(Sets.newHashSet((Object[])new Block[]{Blocks.f_50190_, Blocks.f_50189_}), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowFruitStems);
        BonemealHandler.registerBehavior(Blocks.f_50196_, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowLilyPad);
        BonemealHandler.registerBehavior(Blocks.f_50036_, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowDeadBush);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.f_13037_, () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowSmallFlowers);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.f_13063_, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowCorals);
        BonemealHandler.registerBehavior(Blocks.f_50491_, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowChorus);
        BonemealHandler.registerBehavior(Blocks.f_50490_, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowChorus);
        BonemealHandler.registerBehavior(Blocks.f_50195_, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowMycelium);
        BonemealHandler.registerBehavior(Sets.newHashSet((Object[])new Block[]{Blocks.f_50493_, Blocks.f_50546_, Blocks.f_152481_}), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.server()).allowDirt);
    }
}

