/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.handler;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.universalbonemeal.world.level.block.behavior.BonemealBehavior;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BonemealHandler {
    private static final List<AbstractBehaviorData> BONE_MEAL_BEHAVIORS = Lists.newArrayList();
    private Map<Block, BonemealBehavior> blockToBehavior;

    @SubscribeEvent
    public void onBonemeal(BonemealEvent evt) {
        BlockPos pos;
        Level level;
        this.dissolve();
        BlockState block = evt.getBlock();
        BonemealBehavior behavior = this.blockToBehavior.get(block.m_60734_());
        if (behavior != null && behavior.m_7370_((BlockGetter)(level = evt.getWorld()), pos = evt.getPos(), block, level.f_46443_)) {
            if (level instanceof ServerLevel && behavior.m_5491_(level, level.f_46441_, pos, block)) {
                behavior.m_7719_((ServerLevel)level, level.f_46441_, pos, block);
            }
            evt.setResult(Event.Result.ALLOW);
        }
    }

    private void dissolve() {
        if (this.blockToBehavior == null) {
            HashMap map = Maps.newHashMap();
            for (AbstractBehaviorData behavior : BONE_MEAL_BEHAVIORS) {
                if (!behavior.allow()) continue;
                behavior.compile(map);
            }
            this.blockToBehavior = map;
        }
    }

    public void invalidate() {
        this.blockToBehavior = null;
    }

    public static void registerBehavior(Block block, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockBehaviorData(block, factory, config));
    }

    public static void registerBehavior(Set<Block> blocks, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new MultiBlockBehaviorData(blocks, factory, config));
    }

    public static void registerBehavior(TagKey<Block> tag, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockTagBehaviorData(tag, factory, config));
    }

    private static abstract class AbstractBehaviorData {
        final BonemealBehavior behavior;
        private final BooleanSupplier config;

        public AbstractBehaviorData(Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            this.behavior = factory.get();
            this.config = config;
        }

        public abstract void compile(Map<Block, BonemealBehavior> var1);

        public boolean allow() {
            return this.config.getAsBoolean();
        }
    }

    private static class BlockBehaviorData
    extends AbstractBehaviorData {
        private final Block block;

        public BlockBehaviorData(Block block, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.block = block;
        }

        @Override
        public void compile(Map<Block, BonemealBehavior> map) {
            map.put(this.block, this.behavior);
        }
    }

    private static class MultiBlockBehaviorData
    extends AbstractBehaviorData {
        private final Set<Block> targets;

        public MultiBlockBehaviorData(Set<Block> targets, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.targets = ImmutableSet.copyOf(targets);
        }

        @Override
        public void compile(Map<Block, BonemealBehavior> map) {
            for (Block target : this.targets) {
                map.put(target, this.behavior);
            }
        }
    }

    private static class BlockTagBehaviorData
    extends AbstractBehaviorData {
        private final TagKey<Block> tag;

        public BlockTagBehaviorData(TagKey<Block> tag, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.tag = tag;
        }

        @Override
        public void compile(Map<Block, BonemealBehavior> map) {
            for (Holder value : Registry.f_122824_.m_206058_(this.tag)) {
                map.putIfAbsent((Block)value.m_203334_(), this.behavior);
            }
        }
    }
}

