/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.universalbonemeal.world.level.block.behavior.BonemealBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class CoralBehavior
implements BonemealBehavior {
    private static Map<Block, Block> plantToBlock;

    public boolean m_7370_(BlockGetter p_54870_, BlockPos p_54871_, BlockState p_54872_, boolean p_54873_) {
        return ((LevelReader)p_54870_).m_204166_(p_54871_).m_203565_(Biomes.f_48166_);
    }

    public boolean m_5491_(Level p_54875_, Random p_54876_, BlockPos p_54877_, BlockState p_54878_) {
        return (double)p_54876_.nextFloat() < 0.4;
    }

    public void m_7719_(ServerLevel p_54865_, Random p_54866_, BlockPos p_54867_, BlockState p_54868_) {
        this.place(p_54865_, p_54867_, p_54868_, p_54866_);
    }

    private boolean place(ServerLevel p_54860_, BlockPos p_54861_, BlockState p_54862_, Random p_54863_) {
        p_54860_.m_7471_(p_54861_, false);
        this.dissolve();
        if (this.placeFeature((LevelAccessor)p_54860_, p_54863_, p_54861_, this.getBlockEquivalent(p_54862_, p_54863_).m_49966_())) {
            return true;
        }
        p_54860_.m_7731_(p_54861_, p_54862_, 3);
        return false;
    }

    public static void invalidate() {
        plantToBlock = null;
    }

    private void dissolve() {
        if (plantToBlock == null) {
            HashMap map = Maps.newHashMap();
            for (Holder holder : Registry.f_122824_.m_206058_(BlockTags.f_13063_)) {
                Block block = this.getBlockEquivalent((Block)holder.m_203334_());
                if (block == null) continue;
                map.put((Block)holder.m_203334_(), block);
            }
            plantToBlock = map;
        }
    }

    @Nullable
    private Block getBlockEquivalent(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).m_135815_();
        name = name.substring(0, name.indexOf("_coral"));
        for (Holder holder : Registry.f_122824_.m_206058_(BlockTags.f_13051_)) {
            if (!ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)((Block)holder.m_203334_())).m_135815_().contains(name)) continue;
            return (Block)holder.m_203334_();
        }
        return null;
    }

    private Block getBlockEquivalent(BlockState blockState, Random random) {
        Block block = plantToBlock.get(blockState.m_60734_());
        if (block != null) {
            return block;
        }
        return Registry.f_122824_.m_203431_(BlockTags.f_13051_).flatMap(p_204728_ -> p_204728_.m_203450_(random)).map(Holder::m_203334_).orElseThrow();
    }

    private boolean placeFeature(LevelAccessor level, Random random, BlockPos pos, BlockState blockState) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        int trunkHeight = random.nextInt(3) + 1;
        if (!this.isValidPosition(level, pos, trunkHeight)) {
            return false;
        }
        for (int j = 0; j < trunkHeight; ++j) {
            if (!this.placeCoralBlock(level, random, (BlockPos)mutable, blockState, j == trunkHeight - 1)) {
                return j != 0;
            }
            mutable.m_122173_(Direction.UP);
        }
        BlockPos blockpos = mutable.m_7949_();
        int arms = random.nextInt(3) + 2;
        ArrayList list = Lists.newArrayList((Iterable)Direction.Plane.HORIZONTAL);
        Collections.shuffle(list, random);
        for (Direction direction : list.subList(0, arms)) {
            mutable.m_122190_((Vec3i)blockpos);
            mutable.m_122173_(direction);
            int armLength = random.nextInt(5) + 2;
            int i1 = 0;
            for (int j1 = 0; j1 < armLength && this.placeCoralBlock(level, random, (BlockPos)mutable, blockState, true); ++j1) {
                mutable.m_122173_(Direction.UP);
                if (j1 != 0 && (++i1 < 2 || !(random.nextFloat() < 0.25f))) continue;
                mutable.m_122173_(direction);
                i1 = 0;
            }
        }
        return true;
    }

    private boolean isValidPosition(LevelAccessor p_65099_, BlockPos p_65100_, int height) {
        int i = p_65100_.m_123342_();
        if (i >= p_65099_.m_141937_() + 1 && i + height + 1 < p_65099_.m_151558_()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int j = 0; j <= height + 4; ++j) {
                int k = j < height ? 0 : (j - height) / 2 + 1;
                for (int l = -k; l <= k; ++l) {
                    for (int i1 = -k; i1 <= k; ++i1) {
                        BlockState blockstate1 = p_65099_.m_8055_((BlockPos)mutable.m_122154_((Vec3i)p_65100_, l, j, i1));
                        if (this.isCoralReplaceable(blockstate1)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCoralReplaceable(BlockState blockstate1) {
        return blockstate1.m_60713_(Blocks.f_49990_) || blockstate1.m_204336_(BlockTags.f_13051_) || blockstate1.m_204336_(BlockTags.f_13064_) || blockstate1.m_204336_(BlockTags.f_13052_);
    }

    private boolean placeCoralBlock(LevelAccessor level, Random random, BlockPos pos, BlockState blockState, boolean decorateTop) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = level.m_8055_(pos);
        if (this.isCoralReplaceable(blockstate) && this.isCoralReplaceable(level.m_8055_(blockpos))) {
            level.m_7731_(pos, blockState, 3);
            if (decorateTop) {
                if (random.nextFloat() < 0.25f) {
                    Registry.f_122824_.m_203431_(BlockTags.f_13064_).flatMap(p_204731_ -> p_204731_.m_203450_(random)).map(Holder::m_203334_).ifPresent(p_204720_ -> level.m_7731_(blockpos, p_204720_.m_49966_(), 2));
                } else if (random.nextFloat() < 0.05f) {
                    level.m_7731_(blockpos, (BlockState)Blocks.f_50567_.m_49966_().m_61124_((Property)SeaPickleBlock.f_56074_, (Comparable)Integer.valueOf(random.nextInt(4) + 1)), 2);
                }
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos1;
                if (!(random.nextFloat() < 0.2f) || !level.m_8055_(blockpos1 = pos.m_142300_(direction)).m_60713_(Blocks.f_49990_)) continue;
                Registry.f_122824_.m_203431_(BlockTags.f_13052_).flatMap(p_204728_ -> p_204728_.m_203450_(random)).map(Holder::m_203334_).ifPresent(p_204725_ -> {
                    BlockState blockstate1 = p_204725_.m_49966_();
                    if (blockstate1.m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                        blockstate1 = (BlockState)blockstate1.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)direction);
                    }
                    level.m_7731_(blockpos1, blockstate1, 2);
                });
            }
            return true;
        }
        return false;
    }
}

