/*
 * Decompiled with CFR 0.152.
 */
package com.kitoglav.amethysttoolsmod;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.regex.Pattern;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="amethysttoolsmod")
public class AmethystToolsMod {
    public static final String MODID = "amethysttoolsmod";
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"amethysttoolsmod");
    public static RegistryObject<Item> CLUSTER;
    public static RegistryObject<Item> DUST;

    public AmethystToolsMod() {
        REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        CLUSTER = REGISTRY.register("amethyst_cluster", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
        DUST = REGISTRY.register("amethyst_dust", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> Pattern.compile("minecraft:?(iron|diamond|netherite)").matcher(item.getRegistryName().toString()).find() && item.m_41465_()).forEach(item -> REGISTRY.register(item.getRegistryName().m_135815_() + "_amethyst", () -> {
            Item armorItem$temp = item;
            if (armorItem$temp instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)armorItem$temp;
                return new ArmorItem(AmethystToolsMod.buildArmorMaterial(armorItem.m_40401_()), armorItem.m_40402_(), new Item.Properties().m_41491_(armorItem.m_41471_())){

                    @OnlyIn(value=Dist.CLIENT)
                    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
                        return "amethysttoolsmod:textures/models/" + this.m_40401_().m_6082_() + "_layer_" + (slot != EquipmentSlot.LEGS ? 1 : 2) + ".png";
                    }
                };
            }
            Item tierItem$temp = item;
            if (tierItem$temp instanceof TieredItem) {
                float f;
                TieredItem tierItem = (TieredItem)tierItem$temp;
                TieredItem tieredItem = tierItem;
                if (tieredItem instanceof DiggerItem) {
                    DiggerItem digger = (DiggerItem)tieredItem;
                    f = digger.m_41008_();
                } else {
                    f = ((SwordItem)tierItem).m_43299_();
                }
                float par2 = f - tierItem.m_43314_().m_6631_();
                Constructor<?> constructor = item.getClass().getConstructors()[0];
                try {
                    if (constructor.getParameters()[1].getType() == Integer.TYPE) {
                        return constructor.newInstance(AmethystToolsMod.buildTier(tierItem.m_43314_()), (int)par2, Float.valueOf((float)AmethystToolsMod.buildArray(AttributeModifier.class, item.m_7167_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_))[0].m_22218_()), new Item.Properties().m_41491_(tierItem.m_41471_()));
                    }
                    return constructor.newInstance(AmethystToolsMod.buildTier(tierItem.m_43314_()), Float.valueOf(par2), Float.valueOf((float)AmethystToolsMod.buildArray(AttributeModifier.class, item.m_7167_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_))[0].m_22218_()), new Item.Properties().m_41491_(item.m_41471_()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return null;
        }));
    }

    private static <T> T[] buildArray(Class<T> cl, Collection c) {
        return c.toArray((Object[])Array.newInstance(cl, 0));
    }

    private static Tier buildTier(final Tier tier) {
        return new Tier(){

            public int m_6609_() {
                return (int)((double)tier.m_6609_() * 1.2);
            }

            public float m_6624_() {
                return tier.m_6624_() + 1.0f;
            }

            public float m_6631_() {
                return tier.m_6631_() + 2.0f;
            }

            public int m_6604_() {
                return tier.m_6604_();
            }

            public int m_6601_() {
                return tier.m_6601_();
            }

            public Ingredient m_6282_() {
                return tier.m_6282_();
            }
        };
    }

    private static ArmorMaterial buildArmorMaterial(final ArmorMaterial material) {
        return new ArmorMaterial(){

            public String m_6082_() {
                return material.m_6082_() + "_amethyst";
            }

            public float m_6649_() {
                return material.m_6649_();
            }

            public SoundEvent m_7344_() {
                return material.m_7344_();
            }

            public int m_6646_() {
                return material.m_6646_();
            }

            public int m_7366_(EquipmentSlot slot) {
                return (int)((double)material.m_7366_(slot) * 1.2);
            }

            public int m_7365_(EquipmentSlot slot) {
                return material.m_7365_(slot) + 1;
            }

            public float m_6651_() {
                return material.m_6651_() + (float)(material.m_6651_() > 0.0f ? 1 : 0);
            }

            public Ingredient m_6230_() {
                return material.m_6230_();
            }
        };
    }
}

