/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.battles;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wildcard.buddycards.battles.IBattleIcon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class BattleComponent {
    public static final Codec<Component> COMPONENT_CODEC = Codec.of((Encoder)new Encoder<Component>(){

        public <T> DataResult<T> encode(Component input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, Component.Serializer.m_130716_((Component)input)));
        }
    }, (Decoder)new Decoder<Component>(){

        public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement tag = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
            try {
                return DataResult.success((Object)Pair.of((Object)Component.Serializer.m_130691_((JsonElement)tag), (Object)ops.empty()));
            }
            catch (JsonSyntaxException e) {
                return DataResult.error((String)e.getMessage());
            }
        }
    }, (String)"component");
    public static final Codec<BattleComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)COMPONENT_CODEC.fieldOf("hover").forGetter(BattleComponent::getHoverText), (App)IBattleIcon.ALL_ICON_CODEC.listOf().fieldOf("icons").forGetter(BattleComponent::getBattleIcons)).apply((Applicative)instance, BattleComponent::new));
    public static final Codec<List<BattleComponent>> LIST_CODEC = CODEC.listOf();
    private final Component hoverText;
    private final List<IBattleIcon> battleIcons = new ArrayList<IBattleIcon>();

    public Component getHoverText() {
        return this.hoverText;
    }

    public List<IBattleIcon> getBattleIcons() {
        return this.battleIcons;
    }

    public BattleComponent(Component hoverText) {
        this.hoverText = hoverText;
    }

    public BattleComponent(Component hoverText, List<IBattleIcon> icons) {
        this.hoverText = hoverText;
        this.battleIcons.addAll(icons);
    }
}

