/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.battles;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.wildcard.buddycards.battles.BuddycardBattleIcon;
import com.wildcard.buddycards.battles.TextureBattleIcon;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface IBattleIcon {
    public static final Codec<IBattleIcon> ALL_ICON_CODEC = Codec.either(BuddycardBattleIcon.CODEC, TextureBattleIcon.CODEC).xmap(IBattleIcon::unwrap, IBattleIcon::wrap);

    public int width();

    public static IBattleIcon unwrap(Either<BuddycardBattleIcon, TextureBattleIcon> either) {
        return either.left().map(IBattleIcon.class::cast).orElseGet(() -> (IBattleIcon)either.right().get());
    }

    public static Either<BuddycardBattleIcon, TextureBattleIcon> wrap(IBattleIcon icon) {
        if (icon instanceof BuddycardBattleIcon) {
            BuddycardBattleIcon b = (BuddycardBattleIcon)icon;
            return Either.left((Object)b);
        }
        if (icon instanceof TextureBattleIcon) {
            TextureBattleIcon t = (TextureBattleIcon)icon;
            return Either.right((Object)t);
        }
        throw new RuntimeException("icon is " + icon.getClass().getName() + " however, only BuddycardBattleIcon and TextureBattleIcon are permitted by the seal on IBattleIcon");
    }
}

