/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.battles.game;

import com.google.common.collect.ImmutableListMultimap;
import com.wildcard.buddycards.battles.game.BattleEvent;
import com.wildcard.buddycards.battles.game.BattleGame;

public class BattleAbility {
    public final BattleEvent event;
    public final BattleAbilityFunc ability;
    public final String name;

    public BattleAbility(BattleEvent event, String name, BattleAbilityFunc ability) {
        this.event = event;
        this.name = name;
        this.ability = ability;
    }

    public ImmutableListMultimap<BattleEvent, BattleAbility> single() {
        return new Builder().add(this).build();
    }

    @FunctionalInterface
    public static interface BattleAbilityFunc {
        public boolean trigger(BattleGame var1, int var2, int var3, int var4);
    }

    public static class Builder {
        private ImmutableListMultimap.Builder<BattleEvent, BattleAbility> abilityMap = ImmutableListMultimap.builder();

        public Builder add(BattleAbility ability) {
            this.abilityMap.put((Object)ability.event, (Object)ability);
            return this;
        }

        public ImmutableListMultimap<BattleEvent, BattleAbility> build() {
            return this.abilityMap.build();
        }
    }
}

