/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.battles.game;

import com.wildcard.buddycards.battles.game.BattleAbility;
import com.wildcard.buddycards.battles.game.BattleGame;
import java.util.function.BiFunction;

public class BattleEvent {
    public final String name;
    public static final BattleEvent PLAYED = new BattleEvent("played");
    public static final BattleEvent TURN = new BattleEvent("turn");
    public static final BattleEvent FIGHT = new BattleEvent("fight");
    public static final BattleEvent KILL = new BattleEvent("kill");
    public static final BattleEvent DEATH = new BattleEvent("death");
    public static final BattleEvent OBSERVE_DEATH = new BattleEvent("observe_death");
    public static final BattleEvent DAMAGED = new BattleEvent("damaged");
    public static final BattleEvent POWERED = new BattleEvent("powered");
    public static final BattleEvent ACTIVATED = new BattleEvent("activated");

    public BattleEvent(String name) {
        this.name = name;
    }

    public BattleAbility ability(String name, BattleAbility.BattleAbilityFunc func) {
        return new BattleAbility(this, name, func);
    }

    public static interface Distribution
    extends BiFunction<Integer, BattleGame, int[]> {
        public static final Distribution ALL = (slot, game) -> new int[]{0, 1, 2, 3, 4, 5};
        public static final Distribution ALL_ADJACENT = (slot, game) -> BattleGame.allAdjacent(slot);
        public static final Distribution ADJACENT = (slot, game) -> BattleGame.adjacent(slot);
        public static final Distribution ALL_ENEMY = (slot, game) -> {
            int[] nArray;
            if (slot < 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = 3;
                nArray2[1] = 4;
                nArray = nArray2;
                nArray2[2] = 5;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            return nArray;
        };
        public static final Distribution ROW = (slot, game) -> {
            int[] nArray;
            if (slot < 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray = nArray2;
                nArray2[2] = 2;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 3;
                nArray3[1] = 4;
                nArray = nArray3;
                nArray3[2] = 5;
            }
            return nArray;
        };
        public static final Distribution ROW_OTHER = (slot, game) -> BattleGame.allies(slot);
        public static final Distribution COLUMN = (slot, game) -> {
            int[] nArray = new int[2];
            nArray[0] = slot;
            nArray[1] = BattleGame.opposite(slot);
            return nArray;
        };
        public static final Distribution OPPOSITE = (slot, game) -> {
            int[] nArray = new int[1];
            nArray[0] = BattleGame.opposite(slot);
            return nArray;
        };
        public static final Distribution THIS = (slot, game) -> new int[]{slot};
    }
}

