/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.battles.game;

import com.mojang.logging.LogUtils;
import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.BuddycardBattleIcon;
import com.wildcard.buddycards.battles.TextureBattleIcon;
import com.wildcard.buddycards.battles.game.BattleAbility;
import com.wildcard.buddycards.battles.game.BattleCardState;
import com.wildcard.buddycards.battles.game.BattleEvent;
import com.wildcard.buddycards.battles.game.BattleStatusEffect;
import com.wildcard.buddycards.container.BattleContainer;
import com.wildcard.buddycards.item.BuddycardItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class BattleGame {
    private static final Logger LOGGER = LogUtils.getLogger();
    public BattleContainer container;
    private boolean gameEnded = false;
    private List<BattleAttack> savedAttacks = new ArrayList<BattleAttack>();
    private List<BuddycardItem> items = new ArrayList<BuddycardItem>(6);
    public final BattleCardState[] state = new BattleCardState[6];
    public final int[] turnPower = new int[6];

    public BattleGame(BattleContainer container) {
        int i;
        this.container = container;
        for (i = 0; i < 6; ++i) {
            Item item = container.m_8020_(BattleGame.translateFrom(i)).m_41720_();
            if (item instanceof BuddycardItem) {
                BuddycardItem item2 = (BuddycardItem)item;
                this.items.add(item2);
                continue;
            }
            this.items.add(null);
        }
        for (i = 0; i < 6; ++i) {
            this.state[i] = new BattleCardState(0, BattleStatusEffect.EMPTY);
        }
    }

    public void initFromContainer() {
        for (int i = 0; i < 6; ++i) {
            BuddycardItem item;
            Item item2 = this.container.m_8020_(BattleGame.translateFrom(i)).m_41720_();
            this.items.set(i, item2 instanceof BuddycardItem ? (item = (BuddycardItem)item2) : null);
            this.turnPower[i] = this.state[i].power;
        }
    }

    public boolean hasGameEnded() {
        return this.gameEnded;
    }

    public void beginGame() {
        LOGGER.info("Game Start");
        this.container.tryDrawCard(true);
        this.container.tryDrawCard(true);
        this.container.tryDrawCard(false);
        this.container.tryDrawCard(false);
        this.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.log.buddycards.starting_draw"), List.of(TextureBattleIcon.drawIcon, TextureBattleIcon.drawIcon, TextureBattleIcon.drawIcon, TextureBattleIcon.drawIcon)));
        for (int i = 0; i < 6; ++i) {
            this.state[i] = new BattleCardState(0, BattleStatusEffect.EMPTY);
        }
        this.startTurn();
    }

    public void startTurn() {
        int i;
        LOGGER.info("Player " + this.player() + "'s turn!");
        if (this.isP1()) {
            this.container.energy1 = Math.min(this.container.energy1 + this.container.turnEnergy, 10);
        } else {
            this.container.energy2 = Math.min(this.container.energy2 + this.container.turnEnergy, 10);
        }
        LOGGER.info("Player " + this.player() + " gained " + this.container.turnEnergy + " energy!");
        LOGGER.debug("                         (" + ((this.isP1() ? this.container.energy1 : this.container.energy2) - this.container.turnEnergy) + "->" + (this.isP1() ? this.container.energy1 : this.container.energy2) + ")");
        if (this.container.tryDrawCard(this.isP1())) {
            this.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(this.isP1() ? this.container.name1 : this.container.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.turn_draw")), List.of(TextureBattleIcon.spacerIcon, TextureBattleIcon.drawIcon, TextureBattleIcon.spacerIcon)));
        } else {
            this.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(this.isP1() ? this.container.name1 : this.container.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.turn_fail_draw")), List.of(TextureBattleIcon.spacerIcon, TextureBattleIcon.playIcon, TextureBattleIcon.spacerIcon)));
        }
        this.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(this.isP1() ? this.container.name1 : this.container.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.turn_energy1")).m_130946_("" + this.container.turnEnergy).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.turn_energy2")), List.of(TextureBattleIcon.energyIcon(this.container.turnEnergy))));
        for (i = 0; i < 6; ++i) {
            this.turnPower[i] = this.state[i].power;
        }
        for (i = this.slot(0); i < this.slot(3); ++i) {
            this.trigger(BattleEvent.TURN, i);
        }
        this.container.syncData();
    }

    public boolean endTurn() {
        int i;
        int i2;
        this.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(this.isP1() ? this.container.name1 : this.container.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.turn_attack")), List.of(TextureBattleIcon.spacerIcon, TextureBattleIcon.startAttackIcon, TextureBattleIcon.spacerIcon)));
        for (i2 = this.slot(0); i2 < this.slot(3); ++i2) {
            if (this.items.get(i2) == null) continue;
            int opposite = BattleGame.opposite(i2);
            this.attack(opposite, i2);
            if (this.items.get(opposite) == null) continue;
            this.attack(i2, opposite);
        }
        for (i2 = 0; i2 < 6; ++i2) {
            this.state[i2].power = this.turnPower[i2];
        }
        int[] marked = new int[6];
        for (BattleAttack attack : this.savedAttacks) {
            int target = attack.target;
            int source = attack.source;
            if (this.state[target].power < 0) {
                LOGGER.info((Object)((Object)this.items.get(source)) + " killed " + (Object)((Object)this.items.get(target)));
                this.container.addLog(new BattleComponent((Component)new TranslatableComponent(this.getCard(target).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.death")), List.of(BuddycardBattleIcon.create(this.getCard(target)), TextureBattleIcon.deathIcon)));
                if (!this.trigger(BattleEvent.KILL, source, target, source) || !this.trigger(BattleEvent.DEATH, target, target, source) || !this.trigger(BattleEvent.OBSERVE_DEATH, source, target, source, BattleEvent.Distribution.ALL)) continue;
                this.removeCard(target);
                continue;
            }
            if (target != BattleGame.opposite(source) || this.state[target].power != 0 || this.state[source].power != 0) continue;
            if (marked[target] > 0) {
                marked[source] = 2;
                continue;
            }
            marked[source] = 1;
        }
        for (i = 0; i < 3; ++i) {
            if (marked[i] <= 0 || marked[i + 3] <= 0) continue;
            int target = marked[i] == 1 ? i + 3 : i;
            int source = marked[i] == 1 ? i : i + 3;
            boolean killTarget = this.trigger(BattleEvent.KILL, source, target, source);
            killTarget = (killTarget &= this.turnPower[target] <= 0) && this.trigger(BattleEvent.DEATH, target, target, source) && this.trigger(BattleEvent.OBSERVE_DEATH, source, target, source, BattleEvent.Distribution.ALL);
            boolean killSource = this.trigger(BattleEvent.KILL, target, source, target);
            boolean bl = killSource = (killSource &= this.turnPower[source] <= 0) && this.trigger(BattleEvent.DEATH, source, source, target) && this.trigger(BattleEvent.OBSERVE_DEATH, source, target, source, BattleEvent.Distribution.ALL);
            if (killTarget && this.items.get(target) != null) {
                LOGGER.info((Object)((Object)this.items.get(source)) + " killed " + (Object)((Object)this.items.get(target)));
                this.container.addLog(new BattleComponent((Component)new TranslatableComponent(this.getCard(target).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.death")), List.of(BuddycardBattleIcon.create(this.getCard(target)), TextureBattleIcon.deathIcon)));
                this.removeCard(target);
            }
            if (!killSource || this.items.get(source) == null) continue;
            LOGGER.info((Object)((Object)this.items.get(target)) + " killed " + (Object)((Object)this.items.get(source)));
            this.container.addLog(new BattleComponent((Component)new TranslatableComponent(this.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.death")), List.of(BuddycardBattleIcon.create(this.getCard(source)), TextureBattleIcon.deathIcon)));
            this.removeCard(source);
        }
        this.savedAttacks = new ArrayList<BattleAttack>();
        for (i = 0; i < 6; ++i) {
            this.state[i].power = this.turnPower[i];
        }
        if (this.container.health1 <= 0) {
            this.container.endGame(false);
            this.gameEnded = true;
            return false;
        }
        if (this.container.health2 <= 0) {
            this.container.endGame(true);
            this.gameEnded = true;
            return false;
        }
        this.container.syncData();
        return true;
    }

    public void updatePower() {
        for (int i = 0; i < 6; ++i) {
            this.updatePower(i);
        }
    }

    public void updatePower(int i) {
        this.state[i].power = this.turnPower[i];
        if (this.state[i].power < 0 && this.trigger(BattleEvent.KILL, i, i, i) && this.trigger(BattleEvent.OBSERVE_DEATH, i, i, i, BattleEvent.Distribution.ALL)) {
            this.container.addLog(new BattleComponent((Component)new TranslatableComponent(this.getCard(i).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.death")), List.of(BuddycardBattleIcon.create(this.getCard(i)), TextureBattleIcon.deathIcon)));
            this.trigger(BattleEvent.DEATH, i, i, i);
            this.trigger(BattleEvent.OBSERVE_DEATH, i, i, i, BattleEvent.Distribution.ALL);
            this.removeCard(i);
        }
    }

    public void nextTurn() {
        boolean bl = this.container.isPlayer1Turn = !this.container.isPlayer1Turn;
        if (this.container.turnEnergy < 5) {
            ++this.container.turnEnergy;
        }
        ++this.container.turn;
        this.startTurn();
    }

    public void attack(int target, int source) {
        if (this.items.get(target) == null) {
            if (!this.trigger(BattleEvent.FIGHT, source, target, source, BattleEvent.Distribution.THIS)) {
                return;
            }
            int damage = this.state[source].power;
            if (BattleGame.getOwner(target)) {
                this.container.health1 -= damage;
            } else {
                this.container.health2 -= damage;
            }
            LOGGER.info((Object)((Object)this.items.get(source)) + " dealt " + damage + " damage to Player " + BattleGame.player(!this.isP1()));
            this.container.addLog(new BattleComponent((Component)new TranslatableComponent(this.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.attack1")).m_130946_("" + damage).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.attack2")).m_7220_(BattleGame.getOwner(target) ? this.container.name1 : this.container.name2), List.of(BuddycardBattleIcon.create(this.getCard(source)), TextureBattleIcon.damageIcon(damage))));
        } else {
            if (!this.trigger(BattleEvent.FIGHT, source, target, source)) {
                return;
            }
            int damage = this.state[source].power;
            int n = target;
            this.turnPower[n] = this.turnPower[n] - damage;
            LOGGER.info((Object)((Object)this.items.get(source)) + " dealt " + damage + " damage to " + (Object)((Object)this.items.get(target)));
            this.container.addLog(new BattleComponent((Component)new TranslatableComponent(this.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.attack1")).m_130946_("" + damage).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.attack2")).m_7220_((Component)new TranslatableComponent(this.getCard(target).m_5524_())), List.of(BuddycardBattleIcon.create(this.getCard(source)), TextureBattleIcon.damageIcon(damage), BuddycardBattleIcon.create(this.getCard(target)))));
            if (!this.trigger(BattleEvent.DAMAGED, target, target, source)) {
                return;
            }
            this.savedAttacks.add(new BattleAttack(target, source));
        }
    }

    public void directAttack(int target, int source, int amount) {
        this.directAttack(target, source, amount, true, true);
    }

    public void directAttack(int target, int source, int amount, boolean doAttackTrigger, boolean doDamageTrigger) {
        if (this.items.get(target) == null) {
            if (!this.trigger(BattleEvent.FIGHT, source, target, source)) {
                return;
            }
            if (BattleGame.getOwner(target)) {
                this.container.health1 -= amount;
            } else {
                this.container.health2 -= amount;
            }
            LOGGER.info((Object)((Object)this.items.get(source)) + " dealt " + amount + " damage to Player " + BattleGame.player(!this.isP1()));
        } else {
            if (doAttackTrigger && !this.trigger(BattleEvent.FIGHT, source, target, source)) {
                return;
            }
            int n = target;
            this.turnPower[n] = this.turnPower[n] - amount;
            LOGGER.info((Object)((Object)this.items.get(source)) + " dealt " + amount + " damage to " + (Object)((Object)this.items.get(target)));
            if (doDamageTrigger && !this.trigger(BattleEvent.DAMAGED, target, target, source)) {
                return;
            }
            this.state[target].power = this.turnPower[target];
        }
    }

    public boolean trigger(BattleEvent event, int slot, int target, int source, BattleEvent.Distribution targets, Function<Integer, Boolean> condition) {
        int[] slots = (int[])targets.apply(slot, this);
        for (int i = 0; i < slots.length; ++i) {
            if (!condition.apply(slots[i]).booleanValue() || this.trigger(event, slots[i], target, source)) continue;
            return false;
        }
        return true;
    }

    public boolean trigger(BattleEvent event, int slot, int target, int source, BattleEvent.Distribution targets) {
        int[] slots = (int[])targets.apply(slot, this);
        for (int i = 0; i < slots.length; ++i) {
            if (this.trigger(event, slots[i], target, source)) continue;
            return false;
        }
        return true;
    }

    public boolean trigger(BattleEvent event, int slot, int target, int source) {
        BattleAbility effect;
        BuddycardItem card = this.items.get(slot);
        if (this.state[slot].status != BattleStatusEffect.EMPTY && (effect = this.state[slot].getStatusEffect()) != null && effect.event.equals(event)) {
            if (!effect.ability.trigger(this, slot, target, source)) {
                return false;
            }
            if (this.items.get(slot) != card) {
                return true;
            }
        }
        if (card != null && card.getAbilities().containsKey((Object)event)) {
            for (BattleAbility ability : card.getAbilities().get((Object)event)) {
                if (!ability.ability.trigger(this, slot, target, source)) {
                    return false;
                }
                if (this.items.get(slot) == card) continue;
                return true;
            }
        }
        return true;
    }

    public boolean trigger(BattleEvent event, int slot) {
        return this.trigger(event, slot, slot, slot);
    }

    public boolean playCard(int slot, ItemStack stack, boolean p1) {
        Item item = stack.m_41720_();
        if (!(item instanceof BuddycardItem)) {
            return false;
        }
        BuddycardItem item2 = (BuddycardItem)item;
        int cost = item2.getCost();
        if (this.container.energy(p1) < cost) {
            return false;
        }
        if (p1) {
            this.container.energy1 -= cost;
        } else {
            this.container.energy2 -= cost;
        }
        return this.addCard(slot, stack, item2);
    }

    public boolean addCard(int slot, ItemStack stack, BuddycardItem item) {
        if (this.items.get(slot) != null) {
            return false;
        }
        this.container.m_6836_(BattleGame.translateFrom(slot), stack);
        this.items.set(slot, item);
        this.state[slot] = new BattleCardState(item.getPower(), BattleStatusEffect.EMPTY);
        this.turnPower[slot] = item.getPower();
        this.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(this.isP1() ? this.container.name1 : this.container.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.card_play")).m_7220_((Component)new TranslatableComponent(item.m_5524_())), List.of(BuddycardBattleIcon.create(item), TextureBattleIcon.playIcon)));
        return true;
    }

    public BuddycardItem moveCard(int target, int destination) {
        if (this.items.get(destination) == null) {
            BuddycardItem item = this.items.set(target, null);
            if (item != null) {
                this.items.set(destination, item);
                this.state[destination] = this.state[target];
                this.state[target] = new BattleCardState(0, BattleStatusEffect.EMPTY);
                this.container.m_6836_(BattleGame.translateFrom(destination), this.container.m_7407_(BattleGame.translateFrom(target), 1));
            }
            return item;
        }
        return null;
    }

    public BuddycardItem removeCard(int target) {
        if (this.items.get(target) != null) {
            this.container.returnToDeck(BattleGame.getOwner(target), BattleGame.translateFrom(target));
            this.turnPower[target] = 0;
            this.state[target].power = 0;
            this.state[target].status = BattleStatusEffect.EMPTY;
            return this.items.set(target, null);
        }
        return null;
    }

    public BuddycardItem returnCard(int target) {
        if (this.items.get(target) != null && this.container.tryPutInHand(BattleGame.getOwner(target), this.container.m_8020_(BattleGame.translateFrom(target)))) {
            this.container.m_8016_(BattleGame.translateFrom(target));
            this.turnPower[target] = 0;
            this.state[target].power = 0;
            this.state[target].status = BattleStatusEffect.EMPTY;
            return this.items.set(target, null);
        }
        return null;
    }

    public BuddycardItem getCard(int slot) {
        return this.items.get(slot);
    }

    public boolean canPlay(boolean p1, BuddycardItem card) {
        return p1 == this.isP1() && this.container.energy(p1) >= card.getCost();
    }

    public boolean isP1() {
        return this.container.isPlayer1Turn;
    }

    public char player() {
        return BattleGame.player(this.isP1());
    }

    public static char player(boolean p1) {
        return p1 ? (char)'1' : '2';
    }

    public int slot(int slot) {
        return BattleGame.slot(slot, this.isP1());
    }

    public static int slot(int slot, boolean p1) {
        return p1 ? slot : slot + 3;
    }

    public static boolean isOpposite(int slot, int opposite) {
        return slot % 3 == opposite % 3;
    }

    public static int opposite(int slot) {
        return slot < 3 ? slot + 3 : slot - 3;
    }

    public static int[] adjacent(int slot) {
        int[] nArray;
        switch (slot) {
            default: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
                break;
            }
            case 0: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
                break;
            }
            case 1: {
                int[] nArray4 = new int[2];
                nArray4[0] = 0;
                nArray = nArray4;
                nArray4[1] = 2;
                break;
            }
            case 2: {
                int[] nArray5 = new int[1];
                nArray = nArray5;
                nArray5[0] = 1;
                break;
            }
            case 3: {
                int[] nArray6 = new int[1];
                nArray = nArray6;
                nArray6[0] = 4;
                break;
            }
            case 4: {
                int[] nArray7 = new int[2];
                nArray7[0] = 3;
                nArray = nArray7;
                nArray7[1] = 5;
                break;
            }
            case 5: {
                int[] nArray8 = new int[1];
                nArray = nArray8;
                nArray8[0] = 4;
            }
        }
        return nArray;
    }

    public static int[] allAdjacent(int slot) {
        int[] nArray;
        switch (slot) {
            default: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
                break;
            }
            case 0: {
                int[] nArray3 = new int[2];
                nArray3[0] = 4;
                nArray = nArray3;
                nArray3[1] = 1;
                break;
            }
            case 1: {
                int[] nArray4 = new int[3];
                nArray4[0] = 5;
                nArray4[1] = 0;
                nArray = nArray4;
                nArray4[2] = 2;
                break;
            }
            case 2: {
                int[] nArray5 = new int[2];
                nArray5[0] = 6;
                nArray = nArray5;
                nArray5[1] = 1;
                break;
            }
            case 3: {
                int[] nArray6 = new int[2];
                nArray6[0] = 0;
                nArray = nArray6;
                nArray6[1] = 4;
                break;
            }
            case 4: {
                int[] nArray7 = new int[3];
                nArray7[0] = 1;
                nArray7[1] = 3;
                nArray = nArray7;
                nArray7[2] = 5;
                break;
            }
            case 5: {
                int[] nArray8 = new int[2];
                nArray8[0] = 2;
                nArray = nArray8;
                nArray8[1] = 4;
            }
        }
        return nArray;
    }

    public static int[] allies(int slot) {
        int[] nArray;
        switch (slot) {
            default: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
                break;
            }
            case 0: {
                int[] nArray3 = new int[2];
                nArray3[0] = 1;
                nArray = nArray3;
                nArray3[1] = 2;
                break;
            }
            case 1: {
                int[] nArray4 = new int[2];
                nArray4[0] = 0;
                nArray = nArray4;
                nArray4[1] = 2;
                break;
            }
            case 2: {
                int[] nArray5 = new int[2];
                nArray5[0] = 0;
                nArray = nArray5;
                nArray5[1] = 1;
                break;
            }
            case 3: {
                int[] nArray6 = new int[2];
                nArray6[0] = 4;
                nArray = nArray6;
                nArray6[1] = 5;
                break;
            }
            case 4: {
                int[] nArray7 = new int[2];
                nArray7[0] = 3;
                nArray = nArray7;
                nArray7[1] = 5;
                break;
            }
            case 5: {
                int[] nArray8 = new int[2];
                nArray8[0] = 3;
                nArray = nArray8;
                nArray8[1] = 4;
            }
        }
        return nArray;
    }

    public static boolean getOwner(int slot) {
        return switch (slot) {
            default -> true;
            case 0, 1, 2 -> true;
            case 3, 4, 5 -> false;
        };
    }

    public static int translateTo(int slot) {
        return switch (slot) {
            default -> BattleGame.debugError("Invalid slot translateTo: " + slot);
            case 4 -> 0;
            case 5 -> 1;
            case 6 -> 2;
            case 11 -> 3;
            case 12 -> 4;
            case 13 -> 5;
        };
    }

    public static int translateFrom(int slot) {
        return switch (slot) {
            default -> BattleGame.debugError("Invalid slot translateFrom: " + slot);
            case 0 -> 4;
            case 1 -> 5;
            case 2 -> 6;
            case 3 -> 11;
            case 4 -> 12;
            case 5 -> 13;
        };
    }

    private static int debugError(String errmsg) {
        LOGGER.debug(errmsg);
        return -1;
    }

    private static final class BattleAttack {
        public final int target;
        public final int source;

        public BattleAttack(int target, int source) {
            this.target = target;
            this.source = source;
        }
    }
}

