/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.battles.game;

import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.BuddycardBattleIcon;
import com.wildcard.buddycards.battles.TextureBattleIcon;
import com.wildcard.buddycards.battles.game.BattleAbility;
import com.wildcard.buddycards.battles.game.BattleEvent;
import com.wildcard.buddycards.battles.game.BattleGame;
import com.wildcard.buddycards.container.BattleContainer;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public enum BattleStatusEffect {
    EMPTY,
    FIRE(new BattleAbility(BattleEvent.TURN, "status.fire", BattleStatusEffect.fire()), -39888),
    SLEEP(new BattleAbility(BattleEvent.FIGHT, "status.sleep", BattleStatusEffect.sleep()), -4521994),
    STRENGTH(new BattleAbility(BattleEvent.FIGHT, "status.strength", BattleStatusEffect.strength()), -5570517),
    RESISTANCE(new BattleAbility(BattleEvent.DAMAGED, "status.resistance", BattleStatusEffect.resistance()), -10323834),
    REGENERATION(new BattleAbility(BattleEvent.TURN, "status.regeneration", BattleStatusEffect.regeneration()), -642131),
    WEAKNESS(new BattleAbility(BattleEvent.FIGHT, "status.weakness", BattleStatusEffect.weakness()), -7112923),
    POISON(new BattleAbility(BattleEvent.TURN, "status.poison", BattleStatusEffect.poison()), -11165636),
    WITHER(new BattleAbility(BattleEvent.TURN, "status.wither", BattleStatusEffect.wither()), -16777216),
    AIRBORNE(new BattleAbility(BattleEvent.FIGHT, "status.airborne", BattleStatusEffect.airborne()), -9099),
    STUNNED(new BattleAbility(BattleEvent.FIGHT, "status.stunned", BattleStatusEffect.stunned()), -7112923);

    private final BattleAbility ability;
    private final int color;

    private BattleStatusEffect(BattleAbility ability, int color) {
        this.ability = ability;
        this.color = color;
    }

    private BattleStatusEffect() {
        this.ability = null;
        this.color = 0xFFFFFF;
    }

    public BattleAbility getAbility() {
        return this.ability;
    }

    public int getColor() {
        return this.color;
    }

    private static BattleAbility.BattleAbilityFunc fire() {
        return (game, slot, target, source) -> {
            if (BattleContainer.random.nextBoolean()) {
                game.state[slot].status = EMPTY;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.fire.log1")), List.of(TextureBattleIcon.statusIcon(FIRE), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.statusIcon(EMPTY))));
            } else {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] - 1;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.fire.log2")), List.of(TextureBattleIcon.statusIcon(FIRE), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(slot);
            }
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc sleep() {
        return (game, slot, target, source) -> {
            game.state[slot].status = EMPTY;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.sleep.log")), List.of(TextureBattleIcon.statusIcon(SLEEP), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.statusIcon(EMPTY))));
            return false;
        };
    }

    private static BattleAbility.BattleAbilityFunc strength() {
        return (game, slot, target, source) -> {
            game.state[slot].power += 2;
            game.state[slot].status = EMPTY;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.strength.log")), List.of(TextureBattleIcon.statusIcon(STRENGTH), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(2), TextureBattleIcon.statusIcon(EMPTY))));
            game.updatePower(slot);
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc resistance() {
        return (game, slot, target, source) -> {
            ++game.state[slot].power;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.resistance.log")), List.of(TextureBattleIcon.statusIcon(RESISTANCE), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc regeneration() {
        return (game, slot, target, source) -> {
            ++game.state[slot].power;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.regeneration.log")), List.of(TextureBattleIcon.statusIcon(REGENERATION), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc weakness() {
        return (game, slot, target, source) -> {
            game.state[slot].power -= 2;
            game.state[slot].status = EMPTY;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.weakness.log")), List.of(TextureBattleIcon.statusIcon(SLEEP), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.subtractIcon(2), TextureBattleIcon.statusIcon(EMPTY))));
            game.updatePower(slot);
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc poison() {
        return (game, slot, target, source) -> {
            if (game.state[slot].power > 0) {
                --game.state[slot].power;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.poison.log")), List.of(TextureBattleIcon.statusIcon(SLEEP), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(slot);
            }
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc wither() {
        return (game, slot, target, source) -> {
            --game.state[slot].power;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.wither.log")), List.of(TextureBattleIcon.statusIcon(WITHER), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.subtractIcon(1))));
            game.updatePower(slot);
            return true;
        };
    }

    private static BattleAbility.BattleAbilityFunc airborne() {
        return (game, slot, target, source) -> {
            int damage = game.turnPower[slot];
            if (BattleGame.getOwner(slot)) {
                game.container.health2 -= damage;
            } else {
                game.container.health1 -= damage;
            }
            game.state[slot].status = EMPTY;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.airborne.log1")).m_130946_("" + damage).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.airborne.log2")).m_7220_(BattleGame.getOwner(slot) ? game.container.name2 : game.container.name1).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.airborne.log3")), List.of(TextureBattleIcon.statusIcon(AIRBORNE), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(damage), TextureBattleIcon.statusIcon(EMPTY))));
            return false;
        };
    }

    private static BattleAbility.BattleAbilityFunc stunned() {
        return (game, slot, target, source) -> {
            game.state[slot].status = EMPTY;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.status.stunned.log")), List.of(TextureBattleIcon.statusIcon(STUNNED), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.statusIcon(EMPTY))));
            return false;
        };
    }
}

