/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.block;

import com.google.common.collect.ImmutableMap;
import com.wildcard.buddycards.block.entity.CardDisplayBlockEntity;
import com.wildcard.buddycards.item.BuddycardItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CardDisplayBlock
extends BaseEntityBlock {
    public static final DirectionProperty DIR = BlockStateProperties.f_61374_;
    private static final Map<Direction, VoxelShape> shapes = (Map)Util.m_137537_(() -> {
        HashMap<Direction, VoxelShape> shape = new HashMap<Direction, VoxelShape>();
        shape.put(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0));
        shape.put(Direction.EAST, Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        shape.put(Direction.SOUTH, Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
        shape.put(Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0));
        return ImmutableMap.copyOf(shape);
    });
    protected static final VoxelShape NSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ESHAPE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public CardDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int slot = this.getSlot((Direction)state.m_61143_((Property)DIR), hit.m_82450_());
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CardDisplayBlockEntity) {
            CardDisplayBlockEntity displayTile = (CardDisplayBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (displayTile.getCardInSlot(slot).m_41720_() instanceof BuddycardItem) {
                ItemStack oldCard = displayTile.getCardInSlot(slot);
                if (stack.m_41720_() instanceof BuddycardItem) {
                    ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                    card.m_41751_(stack.m_41783_());
                    displayTile.putCardInSlot(card, slot);
                    stack.m_41774_(1);
                } else {
                    displayTile.putCardInSlot(ItemStack.f_41583_, slot);
                }
                if (!player.m_36356_(oldCard)) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)oldCard);
                }
            } else if (stack.m_41720_() instanceof BuddycardItem) {
                ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                card.m_41751_(stack.m_41783_());
                displayTile.putCardInSlot(card, slot);
                stack.m_41774_(1);
            }
        }
        world.m_46717_(pos, (Block)this);
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CardDisplayBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return shapes.get(state.m_61143_((Property)DIR));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DIR, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIR});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)DIR, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)DIR)));
    }

    private int getSlot(Direction dir, Vec3 hit) {
        double position;
        hit = new Vec3((hit.f_82479_ < 0.0 ? hit.f_82479_ - Math.floor(hit.f_82479_) : hit.f_82479_) % 1.0, (hit.f_82480_ < 0.0 ? hit.f_82480_ - Math.floor(hit.f_82480_) : hit.f_82480_) % 1.0, (hit.f_82481_ < 0.0 ? hit.f_82481_ - Math.floor(hit.f_82481_) : hit.f_82481_) % 1.0);
        int slotIndex = 0;
        if (hit.m_7098_() <= 0.5) {
            slotIndex += 3;
        }
        double d = position = dir.m_122434_() == Direction.Axis.X ? hit.m_7094_() : hit.m_7096_();
        if (dir.m_122428_().m_122421_() == Direction.AxisDirection.NEGATIVE) {
            return slotIndex + Mth.m_14045_((int)Mth.m_14107_((double)(position * 3.0)), (int)0, (int)2) + 1;
        }
        return slotIndex + Mth.m_14045_((int)Mth.m_14107_((double)((1.0 - position) * 3.0)), (int)0, (int)2) + 1;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (world.m_7702_(pos) instanceof CardDisplayBlockEntity) {
            Containers.m_19010_((Level)world, (BlockPos)pos, ((CardDisplayBlockEntity)world.m_7702_(pos)).getInventory());
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CardDisplayBlockEntity) {
            CardDisplayBlockEntity cardDisplay = (CardDisplayBlockEntity)blockEntity;
            return cardDisplay.getCardsAmt();
        }
        return 0;
    }
}

