/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.block;

import com.wildcard.buddycards.block.entity.PlaymatBlockEntity;
import com.wildcard.buddycards.container.BattleContainer;
import com.wildcard.buddycards.item.DeckboxItem;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class PlaymatBlock
extends BaseEntityBlock {
    public static final DirectionProperty DIR = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public PlaymatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PlaymatBlockEntity(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DIR, (Comparable)context.m_8125_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean notMoveByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof PlaymatBlockEntity) {
            PlaymatBlockEntity playmat = (PlaymatBlockEntity)blockEntity;
            Optional blockEntity2 = level.m_141902_(pos.m_142300_((Direction)state.m_61143_((Property)DIR)), (BlockEntityType)BuddycardsEntities.PLAYMAT_ENTITY.get());
            playmat.inGame = false;
            PlaymatBlock.dropPlayMat(playmat, pos, level);
            blockEntity2.ifPresent(be -> PlaymatBlock.dropPlayMat(be, pos, level));
        }
        super.m_6810_(state, level, pos, newState, notMoveByPiston);
    }

    private static void dropPlayMat(PlaymatBlockEntity playmat, BlockPos pos, Level level) {
        if (playmat.container != null) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)new SimpleContainer(new ItemStack[]{playmat.container.m_8020_(0)}));
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)new SimpleContainer(new ItemStack[]{playmat.container.m_8020_(7)}));
            playmat.container = null;
            playmat.inGame = false;
            playmat.p1 = false;
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIR});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)DIR, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)DIR)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlaymatBlockEntity) {
            PlaymatBlockEntity opponent;
            PlaymatBlockEntity self = (PlaymatBlockEntity)blockEntity;
            blockEntity = level.m_7702_(pos.m_142300_((Direction)state.m_61143_((Property)DIR)));
            if (blockEntity instanceof PlaymatBlockEntity && (opponent = (PlaymatBlockEntity)blockEntity).m_58900_().m_61138_((Property)DIR) && ((Direction)opponent.m_58900_().m_61143_((Property)DIR)).m_122424_() == state.m_61143_((Property)DIR)) {
                if (self.p1 && opponent.p1) {
                    self.p1 = false;
                    opponent.p1 = false;
                }
                if (!self.p1 && !opponent.p1) {
                    if (PlaymatBlock.checkP1Pos(self.m_58899_(), opponent.m_58899_())) {
                        self.p1 = true;
                    } else {
                        opponent.p1 = true;
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_7260_(self.m_58899_(), self.m_58900_(), self.m_58900_(), 11);
                        serverLevel.m_7260_(opponent.m_58899_(), opponent.m_58900_(), opponent.m_58900_(), 11);
                    }
                }
                if (self.container == null && opponent.container == null) {
                    self.container = new BattleContainer();
                    self.container.entity = self;
                    opponent.container = self.container;
                    self.m_6596_();
                    opponent.m_6596_();
                } else if (self.container == null || opponent.container == null || self.container != opponent.container) {
                    if (self.p1) {
                        opponent.container = self.container;
                        opponent.m_6596_();
                    } else {
                        self.container = opponent.container;
                        self.m_6596_();
                    }
                }
                if (player.m_21120_(hand).m_41720_() instanceof DeckboxItem && !self.inGame) {
                    player.m_21008_(hand, self.swapDeck(player.m_21120_(hand)));
                    self.setPlayerUUID(player.m_142081_());
                }
                if (self.container != null && self.getContainer().m_8020_(0).m_41720_() instanceof DeckboxItem && self.getContainer().m_8020_(7).m_41720_() instanceof DeckboxItem) {
                    if (!self.inGame) {
                        self.container.startGame();
                        self.inGame = true;
                        opponent.inGame = true;
                        self.m_6596_();
                        opponent.m_6596_();
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (player.m_142081_().equals(self.getPlayerUUID())) {
                            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)self, (BlockPos)pos);
                        }
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public static boolean checkP1Pos(BlockPos self, BlockPos opponent) {
        if (self.m_123341_() > opponent.m_123341_()) {
            return true;
        }
        if (self.m_123341_() < opponent.m_123341_()) {
            return false;
        }
        return self.m_123343_() > opponent.m_123343_();
    }
}

