/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.block.entity;

import com.wildcard.buddycards.menu.ChargerMenu;
import com.wildcard.buddycards.recipe.BuddysteelChargingRecipe;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuddysteelChargerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            BuddysteelChargerBlockEntity.this.m_6596_();
        }
    };
    protected final ContainerData data;
    private LazyOptional<IItemHandler> lazyInventory = LazyOptional.empty();
    private int progress = 0;
    private int maxProgress = 72;

    public BuddysteelChargerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuddycardsEntities.BUDDYSTEEL_CHARGER_TILE.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> BuddysteelChargerBlockEntity.this.progress;
                    case 1 -> BuddysteelChargerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        BuddysteelChargerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        BuddysteelChargerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.buddycards.buddysteel_charger");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ChargerMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyInventory.cast();
        }
        return super.getCapability(cap);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyInventory = LazyOptional.of(() -> this.inventory);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyInventory.invalidate();
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("progress", this.progress);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("inventory"));
        this.progress = compound.m_128451_("progress");
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BuddysteelChargerBlockEntity entity) {
        if (BuddysteelChargerBlockEntity.hasRecipe(entity)) {
            ++entity.progress;
            BuddysteelChargerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (entity.progress > entity.maxProgress) {
                BuddysteelChargerBlockEntity.craftItem(entity);
            }
        } else if (entity.progress != 0) {
            entity.progress = 0;
            BuddysteelChargerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static void craftItem(BuddysteelChargerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inv = new SimpleContainer(entity.inventory.getSlots());
        for (int i = 0; i < entity.inventory.getSlots(); ++i) {
            inv.m_6836_(i, entity.inventory.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)BuddysteelChargingRecipe.Type.INSTANCE, (Container)inv, level);
        for (int i = 0; i < 5; ++i) {
            entity.inventory.extractItem(i, 1, false);
        }
        ItemStack output = ((BuddysteelChargingRecipe)recipe.get()).m_8043_();
        entity.inventory.setStackInSlot(6, new ItemStack((ItemLike)output.m_41720_(), entity.inventory.getStackInSlot(6).m_41613_() + output.m_41613_()));
        entity.progress = 0;
        entity.m_6596_();
    }

    private static boolean hasRecipe(BuddysteelChargerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inv = new SimpleContainer(entity.inventory.getSlots());
        for (int i = 0; i < entity.inventory.getSlots(); ++i) {
            inv.m_6836_(i, entity.inventory.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)BuddysteelChargingRecipe.Type.INSTANCE, (Container)inv, level);
        ItemStack meter = entity.inventory.getStackInSlot(5);
        ItemStack output = entity.inventory.getStackInSlot(6);
        return recipe.isPresent() && meter.m_41782_() && meter.m_41783_().m_128457_("power") >= ((BuddysteelChargingRecipe)recipe.get()).getPowerReq() && (output.m_41619_() || output.m_41720_().equals(((BuddysteelChargingRecipe)recipe.get()).m_8043_().m_41720_()) && output.m_41613_() + ((BuddysteelChargingRecipe)recipe.get()).m_8043_().m_41613_() <= output.m_41741_());
    }
}

