/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.block.entity;

import com.mojang.serialization.DynamicOps;
import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.game.BattleCardState;
import com.wildcard.buddycards.block.PlaymatBlock;
import com.wildcard.buddycards.container.BattleContainer;
import com.wildcard.buddycards.container.DeckboxContainer;
import com.wildcard.buddycards.menu.PlaymatMenu;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PlaymatBlockEntity
extends BlockEntity
implements MenuProvider {
    public BattleContainer container;
    public boolean inGame;
    public boolean p1;
    private Component name;
    private UUID playerUUID;

    public PlaymatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public PlaymatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuddycardsEntities.PLAYMAT_ENTITY.get(), pos, state);
    }

    public Component m_5446_() {
        if (this.name != null) {
            return this.name;
        }
        return new TextComponent("empty");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new PlaymatMenu(i, inventory, this);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.name != null) {
            tag.m_128359_("name", Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128379_("game", this.inGame);
        tag.m_128379_("p1", this.p1);
        if (this.playerUUID != null) {
            tag.m_128362_("player", this.playerUUID);
        }
        if (this.p1) {
            int i;
            tag.m_128365_("log", (Tag)BattleComponent.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.container.battleLog).result().orElse(new ListTag()));
            CompoundTag inv = new CompoundTag();
            for (int i2 = 0; i2 < 14; ++i2) {
                inv.m_128365_("" + i2, (Tag)this.container.m_8020_(i2).m_41739_(new CompoundTag()));
            }
            tag.m_128365_("inv", (Tag)inv);
            if (this.container.deck1 != null) {
                CompoundTag deck1 = new CompoundTag();
                for (i = 0; i < 16; ++i) {
                    deck1.m_128365_("" + i, (Tag)this.container.deck1.m_8020_(i).m_41739_(new CompoundTag()));
                }
                tag.m_128365_("deck1", (Tag)deck1);
            }
            if (this.container.deck2 != null) {
                CompoundTag deck2 = new CompoundTag();
                for (i = 0; i < 16; ++i) {
                    deck2.m_128365_("" + i, (Tag)this.container.deck2.m_8020_(i).m_41739_(new CompoundTag()));
                }
                tag.m_128365_("deck2", (Tag)deck2);
            }
            tag.m_128405_("energy1", this.container.energy1);
            tag.m_128405_("energy2", this.container.energy2);
            tag.m_128405_("health1", this.container.health1);
            tag.m_128405_("health2", this.container.health2);
            tag.m_128405_("turn", this.container.turn);
            tag.m_128405_("turnEnergy", this.container.turnEnergy);
            ListTag gameState = new ListTag();
            for (i = 0; i < 6; ++i) {
                CompoundTag stateTag = new CompoundTag();
                this.container.game.state[i].save(stateTag);
                gameState.add((Object)stateTag);
            }
            tag.m_128365_("gameState", (Tag)gameState);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void m_142339_(Level lvll) {
        super.m_142339_(lvll);
        if (this.f_58857_.f_46443_ && this.container == null) {
            this.container = new BattleContainer();
            this.container.entity = this;
        }
    }

    public void m_142466_(CompoundTag tag) {
        BlockEntity blockEntity;
        super.m_142466_(tag);
        if (tag.m_128441_("name")) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("name"));
        }
        this.inGame = tag.m_128471_("game");
        this.p1 = tag.m_128471_("p1");
        if (tag.m_128441_("player")) {
            this.playerUUID = tag.m_128342_("player");
        }
        if (this.p1) {
            int i;
            if (this.container == null) {
                this.container = new BattleContainer();
            }
            CompoundTag inv = tag.m_128469_("inv");
            for (int i2 = 0; i2 < 14; ++i2) {
                if (!inv.m_128441_("" + i2)) continue;
                this.container.m_6836_(i2, ItemStack.m_41712_((CompoundTag)inv.m_128469_("" + i2)));
            }
            if (tag.m_128441_("deck1")) {
                CompoundTag deck1 = tag.m_128469_("deck1");
                this.container.deck1 = new DeckboxContainer(this.container.m_8020_(0));
                for (i = 0; i < 14; ++i) {
                    if (!deck1.m_128441_("" + i)) continue;
                    this.container.deck1.m_6836_(i, ItemStack.m_41712_((CompoundTag)deck1.m_128469_("" + i)));
                }
            }
            if (tag.m_128441_("deck2")) {
                CompoundTag deck2 = tag.m_128469_("deck2");
                this.container.deck2 = new DeckboxContainer(this.container.m_8020_(7));
                for (i = 0; i < 14; ++i) {
                    if (!deck2.m_128441_("" + i)) continue;
                    this.container.deck2.m_6836_(i, ItemStack.m_41712_((CompoundTag)deck2.m_128469_("" + i)));
                }
            }
            this.container.reload();
            this.container.entity = this;
            if (this.container.battleLog.isEmpty() && tag.m_128441_("log")) {
                ListTag log = tag.m_128437_("log", 10);
                BattleComponent.LIST_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)log).result().ifPresent(result -> this.container.battleLog.addAll((Collection)result.getFirst()));
            }
            this.container.energy1 = tag.m_128451_("energy1");
            this.container.energy2 = tag.m_128451_("energy2");
            this.container.health1 = tag.m_128451_("health1");
            this.container.health2 = tag.m_128451_("health2");
            this.container.turn = tag.m_128451_("turn");
            this.container.turnEnergy = tag.m_128451_("turnEnergy");
            ListTag gameState = tag.m_128437_("gameState", 10);
            for (i = 0; i < 6; ++i) {
                this.container.game.state[i] = BattleCardState.load(gameState.m_128728_(i));
            }
            this.container.game.initFromContainer();
        }
        if (this.inGame && this.f_58857_ != null && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof PlaymatBlock && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_142300_((Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)PlaymatBlock.DIR)))) instanceof PlaymatBlockEntity) {
            PlaymatBlockEntity opponent = (PlaymatBlockEntity)blockEntity;
            if (this.p1) {
                opponent.container = this.container;
            } else {
                this.container = opponent.getContainer();
            }
        }
    }

    public BattleContainer getContainer() {
        return this.container;
    }

    public ItemStack swapDeck(ItemStack itemInHand) {
        ItemStack removedDeck = this.container.m_8020_(this.p1 ? 0 : 7);
        this.container.m_6836_(this.p1 ? 0 : 7, itemInHand);
        this.name = itemInHand.m_41786_();
        this.m_6596_();
        return removedDeck;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }
}

