/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.client;

import com.wildcard.buddycards.client.model.BuddycardsArmorModel;
import com.wildcard.buddycards.client.model.MedalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="buddycards", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BuddycardsLayers {
    public static final ModelLayerLocation HEAD_LAYER = new ModelLayerLocation(new ResourceLocation("buddycards", "armor_head"), "main");
    public static final ModelLayerLocation CHEST_LAYER = new ModelLayerLocation(new ResourceLocation("buddycards", "armor_chest"), "main");
    public static final ModelLayerLocation LEGS_LAYER = new ModelLayerLocation(new ResourceLocation("buddycards", "armor_legs"), "main");
    public static final ModelLayerLocation FEET_LAYER = new ModelLayerLocation(new ResourceLocation("buddycards", "armor_feet"), "main");
    public static final ModelLayerLocation MEDAL_LAYER = new ModelLayerLocation(new ResourceLocation("buddycards", "medal"), "main");
    public static BuddycardsArmorModel<LivingEntity> helmet;
    public static BuddycardsArmorModel<LivingEntity> chestplate;
    public static BuddycardsArmorModel<LivingEntity> leggings;
    public static BuddycardsArmorModel<LivingEntity> boots;
    public static MedalModel<LivingEntity> medal;

    @SubscribeEvent
    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HEAD_LAYER, () -> BuddycardsArmorModel.createBodyLayer(EquipmentSlot.HEAD));
        event.registerLayerDefinition(CHEST_LAYER, () -> BuddycardsArmorModel.createBodyLayer(EquipmentSlot.CHEST));
        event.registerLayerDefinition(LEGS_LAYER, () -> BuddycardsArmorModel.createBodyLayer(EquipmentSlot.LEGS));
        event.registerLayerDefinition(FEET_LAYER, () -> BuddycardsArmorModel.createBodyLayer(EquipmentSlot.FEET));
        event.registerLayerDefinition(MEDAL_LAYER, MedalModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void initModels(EntityRenderersEvent.AddLayers event) {
        helmet = new BuddycardsArmorModel(event.getEntityModels().m_171103_(HEAD_LAYER));
        chestplate = new BuddycardsArmorModel(event.getEntityModels().m_171103_(CHEST_LAYER));
        leggings = new BuddycardsArmorModel(event.getEntityModels().m_171103_(LEGS_LAYER));
        boots = new BuddycardsArmorModel(event.getEntityModels().m_171103_(FEET_LAYER));
        medal = new MedalModel(event.getEntityModels().m_171103_(MEDAL_LAYER));
    }

    public static BuddycardsArmorModel<LivingEntity> getArmor(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> helmet;
            case EquipmentSlot.CHEST -> chestplate;
            case EquipmentSlot.LEGS -> leggings;
            case EquipmentSlot.FEET -> boots;
            default -> null;
        };
    }
}

