/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.wildcard.buddycards.battles.game.BattleGame;
import com.wildcard.buddycards.block.CardDisplayBlock;
import com.wildcard.buddycards.block.entity.PlaymatBlockEntity;
import com.wildcard.buddycards.item.BuddycardItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlaymatBlockRenderer<T extends PlaymatBlockRenderer>
implements BlockEntityRenderer<PlaymatBlockEntity> {
    private static final double[][] NORTH_POSITIONS = new double[][]{{0.8125, 0.0625, 0.75}, {0.5, 0.0625, 0.75}, {0.1875, 0.0625, 0.75}};
    private static final double[][] EAST_POSITIONS = new double[][]{{0.25, 0.0625, 0.8125}, {0.25, 0.0625, 0.5}, {0.25, 0.0625, 0.1875}};
    private static final double[][] SOUTH_POSITIONS = new double[][]{{0.8125, 0.0625, 0.25}, {0.5, 0.0625, 0.25}, {0.1875, 0.0625, 0.25}};
    private static final double[][] WEST_POSITIONS = new double[][]{{0.75, 0.0625, 0.8125}, {0.75, 0.0625, 0.5}, {0.75, 0.0625, 0.1875}};
    private static final Map<Direction, List<Vec3>> positions = (Map)Util.m_137537_(() -> {
        HashMap<Direction, List<Vec3>> tempMap = new HashMap<Direction, List<Vec3>>();
        tempMap.put(Direction.NORTH, PlaymatBlockRenderer.fromDoubleArr(NORTH_POSITIONS));
        tempMap.put(Direction.EAST, PlaymatBlockRenderer.fromDoubleArr(EAST_POSITIONS));
        tempMap.put(Direction.SOUTH, PlaymatBlockRenderer.fromDoubleArr(SOUTH_POSITIONS));
        tempMap.put(Direction.WEST, PlaymatBlockRenderer.fromDoubleArr(WEST_POSITIONS));
        return ImmutableMap.copyOf(tempMap);
    });

    private static List<Vec3> fromDoubleArr(double[][] arr) {
        ArrayList<Vec3> tempList = new ArrayList<Vec3>();
        for (double[] doubles : arr) {
            tempList.add(new Vec3(doubles[0], doubles[1], doubles[2]));
        }
        return ImmutableList.copyOf(tempList);
    }

    public PlaymatBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PlaymatBlockEntity tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)tileEntityIn.m_58900_().m_61143_((Property)CardDisplayBlock.DIR);
        List<Vec3> vec3s = positions.get(direction);
        for (int i = 0; i < 3; ++i) {
            if (tileEntityIn.getContainer() == null) {
                return;
            }
            ItemStack itemstack = tileEntityIn.getContainer().m_8020_(BattleGame.translateFrom(BattleGame.slot(i, tileEntityIn.p1)));
            if (!(itemstack.m_41720_() instanceof BuddycardItem)) continue;
            poseStack.m_85836_();
            Vec3 vec3 = vec3s.get(i);
            poseStack.m_85837_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(360 - direction.m_122416_() * 90)));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            BakedModel ibakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(itemstack, tileEntityIn.m_58904_(), null, 0);
            Minecraft.m_91087_().m_91291_().m_115143_(itemstack, ItemTransforms.TransformType.FIXED, true, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
            poseStack.m_85849_();
        }
    }
}

