/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.container;

import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.TextureBattleIcon;
import com.wildcard.buddycards.battles.game.BattleGame;
import com.wildcard.buddycards.block.entity.PlaymatBlockEntity;
import com.wildcard.buddycards.container.DeckboxContainer;
import com.wildcard.buddycards.item.DeckboxItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BattleContainer
extends SimpleContainer {
    static final String LOG = "battles.log.buddycards.";
    public static final Random random = new Random();
    public boolean isPlayer1Turn = false;
    public PlaymatBlockEntity entity;
    public DeckboxContainer deck1;
    public DeckboxContainer deck2;
    public Component name1;
    public Component name2;
    public int health1;
    public int health2;
    public int energy1;
    public int energy2;
    public int turnEnergy;
    public int turn;
    public BattleGame game;
    public final List<BattleComponent> battleLog = new ArrayList<BattleComponent>();

    public BattleContainer() {
        super(14);
        this.game = new BattleGame(this);
    }

    public void startGame() {
        if (Math.random() < 0.5) {
            this.isPlayer1Turn = true;
        }
        this.name1 = this.m_8020_(0).m_41611_().m_6879_();
        this.name2 = this.m_8020_(7).m_41611_().m_6879_();
        this.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(this.isPlayer1Turn ? this.name1 : this.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.go_first")), List.of(TextureBattleIcon.playIcon)));
        this.deck1 = new DeckboxContainer(this.m_8020_(0));
        this.deck2 = new DeckboxContainer(this.m_8020_(7));
        this.deck1.startOpen();
        this.deck2.startOpen();
        this.health2 = 20;
        this.health1 = 20;
        this.energy2 = 0;
        this.energy1 = 0;
        this.turnEnergy = 1;
        this.turn = 1;
        this.game = new BattleGame(this);
        this.game.beginGame();
        this.entity.m_6596_();
    }

    public void reload() {
        this.name1 = this.m_8020_(0).m_41611_();
        this.name2 = this.m_8020_(7).m_41611_();
    }

    public boolean tryDrawCard(boolean p1) {
        if (!(this.m_8020_(p1 ? 0 : 7).m_41720_() instanceof DeckboxItem)) {
            return false;
        }
        if (p1 && this.deck1.m_7983_() || !p1 && this.deck2.m_7983_()) {
            return false;
        }
        for (int i = p1 ? 1 : 8; i < (p1 ? 4 : 11); ++i) {
            ItemStack card;
            if (!this.m_8020_(i).m_41619_()) continue;
            ItemStack itemStack = card = p1 ? this.deck1.m_7407_(random.nextInt(16), 1) : this.deck2.m_7407_(random.nextInt(16), 1);
            while (card.m_41619_()) {
                card = p1 ? this.deck1.m_7407_(random.nextInt(16), 1) : this.deck2.m_7407_(random.nextInt(16), 1);
            }
            this.m_6836_(i, card);
            if (p1) {
                this.deck1.m_6596_();
            } else {
                this.deck2.m_6596_();
            }
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean tryPutInHand(boolean p1, ItemStack card) {
        for (int i = p1 ? 1 : 8; i < (p1 ? 4 : 11); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, card);
            this.m_6596_();
            System.out.println("CARD PUT IN HAND");
            return true;
        }
        return false;
    }

    public boolean returnToDeck(boolean p1, int slot) {
        ItemStack stack = this.m_7407_(slot, 1);
        if (p1) {
            return this.deck1.m_19173_(stack).m_41619_();
        }
        return this.deck2.m_19173_(stack).m_41619_();
    }

    public void endGame(boolean p1Victory) {
        System.out.println("Player " + BattleGame.player(p1Victory) + " Wins!");
        this.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(p1Victory ? this.name1 : this.name2).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.victory")), List.of(TextureBattleIcon.spacerIcon, TextureBattleIcon.winIcon, TextureBattleIcon.spacerIcon)));
        this.deck1.saveStats(p1Victory);
        this.deck2.saveStats(!p1Victory);
        this.syncData();
    }

    public int energy(boolean p1) {
        return p1 ? this.energy1 : this.energy2;
    }

    public void spendEnergy(boolean p1, int amt) {
        if (p1) {
            this.energy1 -= amt;
        } else {
            this.energy2 -= amt;
        }
    }

    public void addLog(BattleComponent log) {
        this.battleLog.add(0, log);
    }

    public void syncData() {
        Level level;
        if (this.entity != null && (level = this.entity.m_58904_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7260_(this.entity.m_58899_(), this.entity.m_58900_(), this.entity.m_58900_(), 11);
        }
    }
}

