/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.core;

import com.wildcard.buddycards.core.BuddycardsAPI;
import com.wildcard.buddycards.item.BuddycardItem;
import com.wildcard.buddycards.item.BuddysteelSetMedalItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class BuddycardSet {
    protected final List<BuddycardItem> cards = new ArrayList<BuddycardItem>();
    protected final String name;
    @Nullable
    protected Supplier<BuddysteelSetMedalItem> medalSupplier;
    @Nullable
    protected String descriptionId;

    public BuddycardSet(String name) {
        this.name = name;
        BuddycardsAPI.registerSet(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = "item.buddycards.buddycard.set_" + this.getName();
        }
        return this.descriptionId;
    }

    public void setMedal(Supplier<BuddysteelSetMedalItem> supplier) {
        this.medalSupplier = supplier;
    }

    @Nullable
    public BuddysteelSetMedalItem getMedal() {
        if (this.medalSupplier == null) {
            return null;
        }
        return this.medalSupplier.get();
    }

    public void addCard(BuddycardItem card) {
        this.cards.add(card);
    }

    public Collection<BuddycardItem> getCards() {
        return Collections.unmodifiableCollection(this.cards);
    }
}

