/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.datagen;

import com.wildcard.buddycards.core.BuddycardSet;
import com.wildcard.buddycards.core.BuddycardsAPI;
import com.wildcard.buddycards.item.BuddycardItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CardModelGen
extends ItemModelProvider {
    public CardModelGen(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        for (BuddycardItem card : BuddycardsAPI.getAllCards()) {
            this.genCardModel(card.getSet(), card.getCardNumber());
        }
    }

    void genCardModel(BuddycardSet set, int cardNum) {
        String setName = set.getName();
        ItemModelBuilder card = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/buddycard_" + setName + cardNum)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/buddycard")))).texture("layer0", new ResourceLocation("buddycards", "item/" + setName + "_set/" + cardNum));
        for (int i = 1; i <= 5; ++i) {
            card.override().predicate(new ResourceLocation("buddycards", "grade"), (float)i).model(this.genGradedCardModel(setName, cardNum, i));
        }
    }

    ModelFile genGradedCardModel(String setName, int cardNum, int grade) {
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/buddycard_" + setName + cardNum + "_g" + grade)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/buddycard")))).texture("layer0", new ResourceLocation("buddycards", "item/" + setName + "_set/" + cardNum))).texture("layer1", new ResourceLocation("buddycards", "item/grade" + grade));
    }
}

