/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.entity;

import com.mojang.datafixers.util.Pair;
import com.wildcard.buddycards.core.BuddycardsAPI;
import com.wildcard.buddycards.item.BuddycardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EnderlingEntity
extends PathfinderMob
implements Npc,
Nameable {
    final ArrayList<Pair<ItemStack, ItemStack>> goalTrades = new ArrayList();
    boolean cheap;
    int timer = 0;

    public EnderlingEntity(EntityType<? extends PathfinderMob> type, Level lvl) {
        super(type, lvl);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.cheap = lvl.m_5822_().nextDouble() < 0.1;
        this.m_21553_(true);
        if (lvl instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)lvl;
            this.setupGoalItems(serverLevel);
        }
    }

    public static AttributeSupplier setupAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 6.0).m_22265_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 0.75, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BuddycardsItems.ZYLEX.get(), (ItemLike)BuddycardsItems.VOID_ZYLEX.get()}), false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5, 0.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, (double)0.6f, 1.5f, 6.0f));
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(3);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11849_;
    }

    protected void m_8024_() {
        float f;
        if (this.f_19853_.m_46461_() && this.f_19797_ >= 600 && (f = this.m_6073_()) > 0.5f && this.f_19853_.m_45527_(this.m_142538_()) && this.f_19796_.nextFloat() * 60.0f < (f - 0.4f) * 2.0f) {
            this.teleport();
        }
        super.m_8024_();
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 32.0;
            double d1 = this.m_20186_() + (double)this.f_19796_.nextInt(32) - 32.0;
            double d2 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        if (blockstate.m_60767_().m_76334_() && !blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)this, p_70825_1_, p_70825_3_, p_70825_5_);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean success = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (success && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return success;
        }
        return false;
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                for (Pair<ItemStack, ItemStack> goalTrade : this.goalTrades) {
                    if (!EnderlingEntity.cardsMatch((ItemStack)goalTrade.getFirst(), this.m_21205_())) continue;
                    Vec3 pos = this.m_20182_().m_82520_(0.0, 1.0, 0.0);
                    Player player = this.f_19853_.m_45930_((Entity)this, 5.0);
                    if (player != null) {
                        pos = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
                    }
                    BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)((ItemStack)goalTrade.getSecond()), (Vec3)pos);
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    this.goalTrades.remove(goalTrade);
                    if (((ItemStack)goalTrade.getFirst()).m_41720_().equals(BuddycardsItems.ZYLEX.get())) {
                        this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)new ItemStack((ItemLike)BuddycardsItems.ZYLEX.get()), (Object)EnderlingEntity.getBarterResult(this.f_19853_, false)));
                    }
                    if (!((ItemStack)goalTrade.getFirst()).m_41720_().equals(BuddycardsItems.VOID_ZYLEX.get())) break;
                    this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)new ItemStack((ItemLike)BuddycardsItems.VOID_ZYLEX.get()), (Object)EnderlingEntity.getBarterResult(this.f_19853_, true)));
                    break;
                }
            }
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    public void setupGoalItems(ServerLevel lvl) {
        Random rand = lvl.m_5822_();
        List<BuddycardItem> cards = BuddycardsAPI.getAllCards().stream().filter(BuddycardItem::shouldLoad).toList();
        for (int i = 0; i < 12; ++i) {
            ItemStack card = new ItemStack((ItemLike)cards.get(rand.nextInt(cards.size())));
            if (i % 3 == 0) {
                BuddycardItem.setShiny(card);
            }
            this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)card, (Object)EnderlingEntity.getCardSellValue(card, rand, this.cheap)));
            if (i >= 4) continue;
            ItemStack card2 = card.m_41777_();
            card2.m_41784_().m_128405_("grade", rand.nextInt(1, 5));
            this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)card2, (Object)EnderlingEntity.getCardSellValue(card2, rand, this.cheap)));
        }
        this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)new ItemStack((ItemLike)BuddycardsItems.ZYLEX.get()), (Object)EnderlingEntity.getBarterResult(this.f_19853_, false)));
        this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)new ItemStack((ItemLike)BuddycardsItems.VOID_ZYLEX.get()), (Object)EnderlingEntity.getBarterResult(this.f_19853_, true)));
    }

    public static ItemStack getBarterResult(Level level, boolean voidZylex) {
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            LootContext.Builder builder = new LootContext.Builder(lvl).m_78977_(lvl.f_46441_);
            if (voidZylex) {
                LootTable table = lvl.m_142572_().m_129898_().m_79217_(new ResourceLocation("buddycards", "gameplay/void_zylex_barter"));
                List items = table.m_79129_(builder.m_78975_(LootContextParamSets.f_81410_));
                return (ItemStack)items.get(0);
            }
            LootTable table = lvl.m_142572_().m_129898_().m_79217_(new ResourceLocation("buddycards", "gameplay/zylex_barter"));
            List items = table.m_79129_(builder.m_78975_(LootContextParamSets.f_81410_));
            return (ItemStack)items.get(0);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getCardSellValue(ItemStack card, Random rand, boolean cheap) {
        int value = rand.nextInt(1, 4);
        boolean markVoid = false;
        if (card.m_41791_() == Rarity.RARE) {
            value += 2;
        }
        if (card.m_41791_() == Rarity.EPIC) {
            value += 6;
        }
        if (card.m_41790_()) {
            value += 3;
        }
        if (card.m_41782_() && card.m_41783_().m_128441_("grade")) {
            int grade = card.m_41783_().m_128451_("grade");
            if (grade == 1) {
                value -= 2;
            } else if (grade == 2) {
                value += 2;
            } else if (grade == 3) {
                value *= 2;
            } else if (grade == 4) {
                value *= 4;
            } else if (grade == 5) {
                value *= 18;
            }
            if (grade >= 3 || card.m_41791_() == Rarity.EPIC) {
                markVoid = true;
            }
        }
        if (cheap) {
            value /= 2;
        }
        if ((value = Math.max(1, value)) >= 9) {
            if (rand.nextInt(3) == 0) {
                markVoid = true;
            }
            if (markVoid) {
                return new ItemStack((ItemLike)BuddycardsItems.VOID_ZYLEX.get(), value / 9);
            }
            return new ItemStack((ItemLike)BuddycardsItems.ZYLEX.get(), value / 9);
        }
        return new ItemStack((ItemLike)BuddycardsItems.ZYLEX_NUGGET.get(), value);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.timer == 0 && this.goalTrades.stream().anyMatch(i -> EnderlingEntity.cardsMatch((ItemStack)i.getFirst(), player.m_21120_(hand)))) {
            this.m_21008_(InteractionHand.MAIN_HAND, player.m_21205_().m_41620_(1));
            this.timer = 200;
        }
        return InteractionResult.PASS;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TradeTimer", this.timer);
        tag.m_128379_("Cheap", this.cheap);
        ListTag tradesTag = new ListTag();
        for (Pair<ItemStack, ItemStack> trade : this.goalTrades) {
            CompoundTag tradeTag = new CompoundTag();
            tradeTag.m_128365_("Goal", (Tag)((ItemStack)trade.getFirst()).m_41739_(new CompoundTag()));
            tradeTag.m_128365_("Reward", (Tag)((ItemStack)trade.getSecond()).m_41739_(new CompoundTag()));
            tradesTag.add((Object)tradeTag);
        }
        tag.m_128365_("GoalTrades", (Tag)tradesTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.timer = tag.m_128451_("TradeTimer");
        this.cheap = tag.m_128471_("Cheap");
        this.goalTrades.clear();
        for (Tag tradeTag : tag.m_128437_("GoalTrades", 10)) {
            this.goalTrades.add((Pair<ItemStack, ItemStack>)new Pair((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)tradeTag).m_128469_("Goal")), (Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)tradeTag).m_128469_("Reward"))));
        }
    }

    public boolean m_7243_(ItemStack stack) {
        return this.goalTrades.stream().anyMatch(i -> EnderlingEntity.cardsMatch((ItemStack)i.getFirst(), stack));
    }

    protected void m_7581_(ItemEntity item) {
        if (this.m_21205_().m_41619_()) {
            this.m_21053_(item);
            this.m_7938_((Entity)item, 1);
            this.m_21008_(InteractionHand.MAIN_HAND, item.m_32055_().m_41620_(1));
            this.timer = 200;
        }
    }

    static boolean cardsMatch(ItemStack a, ItemStack b) {
        return a.m_41720_().equals(b.m_41720_()) && BuddycardItem.hasFoil(a) == BuddycardItem.hasFoil(b) && BuddycardItem.getGrade(a) == BuddycardItem.getGrade(b);
    }
}

